package zio.aws.clouddirectory.model
import scala.jdk.CollectionConverters.*
sealed trait BatchReadExceptionType {
  def unwrap: software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType
}
object BatchReadExceptionType {
  def wrap(
      value: software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType
  ): zio.aws.clouddirectory.model.BatchReadExceptionType = value match {
    case software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.VALIDATION_EXCEPTION =>
      val r = ValidationException
      r
    case software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.INVALID_ARN_EXCEPTION =>
      val r = InvalidArnException
      r
    case software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.RESOURCE_NOT_FOUND_EXCEPTION =>
      val r = ResourceNotFoundException
      r
    case software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.INVALID_NEXT_TOKEN_EXCEPTION =>
      val r = InvalidNextTokenException
      r
    case software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.ACCESS_DENIED_EXCEPTION =>
      val r = AccessDeniedException
      r
    case software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.NOT_NODE_EXCEPTION =>
      val r = NotNodeException
      r
    case software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.FACET_VALIDATION_EXCEPTION =>
      val r = FacetValidationException
      r
    case software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.CANNOT_LIST_PARENT_OF_ROOT_EXCEPTION =>
      val r = CannotListParentOfRootException
      r
    case software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.NOT_INDEX_EXCEPTION =>
      val r = NotIndexException
      r
    case software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.NOT_POLICY_EXCEPTION =>
      val r = NotPolicyException
      r
    case software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.DIRECTORY_NOT_ENABLED_EXCEPTION =>
      val r = DirectoryNotEnabledException
      r
    case software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.LIMIT_EXCEEDED_EXCEPTION =>
      val r = LimitExceededException
      r
    case software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.INTERNAL_SERVICE_EXCEPTION =>
      val r = InternalServiceException
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.clouddirectory.model.BatchReadExceptionType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType =
      software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.UNKNOWN_TO_SDK_VERSION
  }
  case object ValidationException
      extends zio.aws.clouddirectory.model.BatchReadExceptionType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType =
      software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.VALIDATION_EXCEPTION
  }
  case object InvalidArnException
      extends zio.aws.clouddirectory.model.BatchReadExceptionType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType =
      software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.INVALID_ARN_EXCEPTION
  }
  case object ResourceNotFoundException
      extends zio.aws.clouddirectory.model.BatchReadExceptionType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType =
      software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.RESOURCE_NOT_FOUND_EXCEPTION
  }
  case object InvalidNextTokenException
      extends zio.aws.clouddirectory.model.BatchReadExceptionType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType =
      software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.INVALID_NEXT_TOKEN_EXCEPTION
  }
  case object AccessDeniedException
      extends zio.aws.clouddirectory.model.BatchReadExceptionType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType =
      software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.ACCESS_DENIED_EXCEPTION
  }
  case object NotNodeException
      extends zio.aws.clouddirectory.model.BatchReadExceptionType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType =
      software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.NOT_NODE_EXCEPTION
  }
  case object FacetValidationException
      extends zio.aws.clouddirectory.model.BatchReadExceptionType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType =
      software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.FACET_VALIDATION_EXCEPTION
  }
  case object CannotListParentOfRootException
      extends zio.aws.clouddirectory.model.BatchReadExceptionType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType =
      software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.CANNOT_LIST_PARENT_OF_ROOT_EXCEPTION
  }
  case object NotIndexException
      extends zio.aws.clouddirectory.model.BatchReadExceptionType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType =
      software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.NOT_INDEX_EXCEPTION
  }
  case object NotPolicyException
      extends zio.aws.clouddirectory.model.BatchReadExceptionType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType =
      software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.NOT_POLICY_EXCEPTION
  }
  case object DirectoryNotEnabledException
      extends zio.aws.clouddirectory.model.BatchReadExceptionType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType =
      software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.DIRECTORY_NOT_ENABLED_EXCEPTION
  }
  case object LimitExceededException
      extends zio.aws.clouddirectory.model.BatchReadExceptionType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType =
      software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.LIMIT_EXCEEDED_EXCEPTION
  }
  case object InternalServiceException
      extends zio.aws.clouddirectory.model.BatchReadExceptionType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType =
      software.amazon.awssdk.services.clouddirectory.model.BatchReadExceptionType.INTERNAL_SERVICE_EXCEPTION
  }
}
