package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchListAttachedIndicesResponse(
    indexAttachments: Optional[
      Iterable[zio.aws.clouddirectory.model.IndexAttachment]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchListAttachedIndicesResponse = {
    import BatchListAttachedIndicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchListAttachedIndicesResponse
      .builder()
      .optionallyWith(
        indexAttachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.indexAttachments)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchListAttachedIndicesResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchListAttachedIndicesResponse
      .wrap(buildAwsValue())
}
object BatchListAttachedIndicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchListAttachedIndicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.BatchListAttachedIndicesResponse =
      zio.aws.clouddirectory.model.BatchListAttachedIndicesResponse(
        indexAttachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def indexAttachments
        : Optional[List[zio.aws.clouddirectory.model.IndexAttachment.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getIndexAttachments: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.IndexAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField("indexAttachments", indexAttachments)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListAttachedIndicesResponse
  ) extends zio.aws.clouddirectory.model.BatchListAttachedIndicesResponse.ReadOnly {
    override val indexAttachments: Optional[
      List[zio.aws.clouddirectory.model.IndexAttachment.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.indexAttachments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.IndexAttachment.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListAttachedIndicesResponse
  ): zio.aws.clouddirectory.model.BatchListAttachedIndicesResponse.ReadOnly =
    new Wrapper(impl)
}
