package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.AttributeName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttributeNameAndValue(
    attributeName: AttributeName,
    value: zio.aws.clouddirectory.model.TypedAttributeValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValue = {
    import AttributeNameAndValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValue
      .builder()
      .attributeName(AttributeName.unwrap(attributeName): java.lang.String)
      .value(value.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.AttributeNameAndValue.ReadOnly =
    zio.aws.clouddirectory.model.AttributeNameAndValue.wrap(buildAwsValue())
}
object AttributeNameAndValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.AttributeNameAndValue =
      zio.aws.clouddirectory.model
        .AttributeNameAndValue(attributeName, value.asEditable)
    def attributeName: AttributeName
    def value: zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly
    def getAttributeName: ZIO[Any, Nothing, AttributeName] =
      ZIO.succeed(attributeName)
    def getValue: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly
    ] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValue
  ) extends zio.aws.clouddirectory.model.AttributeNameAndValue.ReadOnly {
    override val attributeName: AttributeName =
      zio.aws.clouddirectory.model.primitives
        .AttributeName(impl.attributeName())
    override val value
        : zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly =
      zio.aws.clouddirectory.model.TypedAttributeValue.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValue
  ): zio.aws.clouddirectory.model.AttributeNameAndValue.ReadOnly = new Wrapper(
    impl
  )
}
