package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TypedLinkSpecifier(
    typedLinkFacet: zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName,
    sourceObjectReference: zio.aws.clouddirectory.model.ObjectReference,
    targetObjectReference: zio.aws.clouddirectory.model.ObjectReference,
    identityAttributeValues: Iterable[
      zio.aws.clouddirectory.model.AttributeNameAndValue
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier = {
    import TypedLinkSpecifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier
      .builder()
      .typedLinkFacet(typedLinkFacet.buildAwsValue())
      .sourceObjectReference(sourceObjectReference.buildAwsValue())
      .targetObjectReference(targetObjectReference.buildAwsValue())
      .identityAttributeValues(identityAttributeValues.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly =
    zio.aws.clouddirectory.model.TypedLinkSpecifier.wrap(buildAwsValue())
}
object TypedLinkSpecifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.TypedLinkSpecifier =
      zio.aws.clouddirectory.model.TypedLinkSpecifier(
        typedLinkFacet.asEditable,
        sourceObjectReference.asEditable,
        targetObjectReference.asEditable,
        identityAttributeValues.map { item =>
          item.asEditable
        }
      )
    def typedLinkFacet
        : zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName.ReadOnly
    def sourceObjectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def targetObjectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def identityAttributeValues
        : List[zio.aws.clouddirectory.model.AttributeNameAndValue.ReadOnly]
    def getTypedLinkFacet: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName.ReadOnly
    ] = ZIO.succeed(typedLinkFacet)
    def getSourceObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(sourceObjectReference)
    def getTargetObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(targetObjectReference)
    def getIdentityAttributeValues: ZIO[Any, Nothing, List[
      zio.aws.clouddirectory.model.AttributeNameAndValue.ReadOnly
    ]] = ZIO.succeed(identityAttributeValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier
  ) extends zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly {
    override val typedLinkFacet
        : zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName.ReadOnly =
      zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName
        .wrap(impl.typedLinkFacet())
    override val sourceObjectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference
        .wrap(impl.sourceObjectReference())
    override val targetObjectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference
        .wrap(impl.targetObjectReference())
    override val identityAttributeValues
        : List[zio.aws.clouddirectory.model.AttributeNameAndValue.ReadOnly] =
      impl
        .identityAttributeValues()
        .asScala
        .map { item =>
          zio.aws.clouddirectory.model.AttributeNameAndValue.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier
  ): zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly = new Wrapper(
    impl
  )
}
