package zio.aws.clouddirectory.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.clouddirectory.model.primitives.{NumberResults, NextToken, Arn}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListObjectPoliciesRequest(
    directoryArn: Arn,
    objectReference: zio.aws.clouddirectory.model.ObjectReference,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[NumberResults] = Optional.Absent,
    consistencyLevel: Optional[zio.aws.clouddirectory.model.ConsistencyLevel] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesRequest = {
    import ListObjectPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .objectReference(objectReference.buildAwsValue())
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(consistencyLevel.map(value => value.unwrap))(
        _.consistencyLevel
      )
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListObjectPoliciesRequest.ReadOnly =
    zio.aws.clouddirectory.model.ListObjectPoliciesRequest.wrap(buildAwsValue())
}
object ListObjectPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListObjectPoliciesRequest =
      zio.aws.clouddirectory.model.ListObjectPoliciesRequest(
        directoryArn,
        objectReference.asEditable,
        nextToken.map(value => value),
        maxResults.map(value => value),
        consistencyLevel.map(value => value)
      )
    def directoryArn: Arn
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def nextToken: Optional[NextToken]
    def maxResults: Optional[NumberResults]
    def consistencyLevel
        : Optional[zio.aws.clouddirectory.model.ConsistencyLevel]
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getConsistencyLevel
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.ConsistencyLevel] =
      AwsError.unwrapOptionField("consistencyLevel", consistencyLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesRequest
  ) extends zio.aws.clouddirectory.model.ListObjectPoliciesRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val maxResults: Optional[NumberResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
    override val consistencyLevel
        : Optional[zio.aws.clouddirectory.model.ConsistencyLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consistencyLevel())
        .map(value => zio.aws.clouddirectory.model.ConsistencyLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesRequest
  ): zio.aws.clouddirectory.model.ListObjectPoliciesRequest.ReadOnly =
    new Wrapper(impl)
}
