package zio.aws.clouddirectory.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.clouddirectory.model.primitives.{NumberResults, NextToken, Arn}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAttachedIndicesRequest(
    directoryArn: Arn,
    targetReference: zio.aws.clouddirectory.model.ObjectReference,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[NumberResults] = Optional.Absent,
    consistencyLevel: Optional[zio.aws.clouddirectory.model.ConsistencyLevel] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesRequest = {
    import ListAttachedIndicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .targetReference(targetReference.buildAwsValue())
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(consistencyLevel.map(value => value.unwrap))(
        _.consistencyLevel
      )
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListAttachedIndicesRequest.ReadOnly =
    zio.aws.clouddirectory.model.ListAttachedIndicesRequest
      .wrap(buildAwsValue())
}
object ListAttachedIndicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListAttachedIndicesRequest =
      zio.aws.clouddirectory.model.ListAttachedIndicesRequest(
        directoryArn,
        targetReference.asEditable,
        nextToken.map(value => value),
        maxResults.map(value => value),
        consistencyLevel.map(value => value)
      )
    def directoryArn: Arn
    def targetReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def nextToken: Optional[NextToken]
    def maxResults: Optional[NumberResults]
    def consistencyLevel
        : Optional[zio.aws.clouddirectory.model.ConsistencyLevel]
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getTargetReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(targetReference)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getConsistencyLevel
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.ConsistencyLevel] =
      AwsError.unwrapOptionField("consistencyLevel", consistencyLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesRequest
  ) extends zio.aws.clouddirectory.model.ListAttachedIndicesRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val targetReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.targetReference())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val maxResults: Optional[NumberResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
    override val consistencyLevel
        : Optional[zio.aws.clouddirectory.model.ConsistencyLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consistencyLevel())
        .map(value => zio.aws.clouddirectory.model.ConsistencyLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesRequest
  ): zio.aws.clouddirectory.model.ListAttachedIndicesRequest.ReadOnly =
    new Wrapper(impl)
}
