package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DetachTypedLinkRequest(
    directoryArn: Arn,
    typedLinkSpecifier: zio.aws.clouddirectory.model.TypedLinkSpecifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.DetachTypedLinkRequest = {
    import DetachTypedLinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.DetachTypedLinkRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .typedLinkSpecifier(typedLinkSpecifier.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.DetachTypedLinkRequest.ReadOnly =
    zio.aws.clouddirectory.model.DetachTypedLinkRequest.wrap(buildAwsValue())
}
object DetachTypedLinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.DetachTypedLinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.DetachTypedLinkRequest =
      zio.aws.clouddirectory.model
        .DetachTypedLinkRequest(directoryArn, typedLinkSpecifier.asEditable)
    def directoryArn: Arn
    def typedLinkSpecifier
        : zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getTypedLinkSpecifier: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    ] = ZIO.succeed(typedLinkSpecifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.DetachTypedLinkRequest
  ) extends zio.aws.clouddirectory.model.DetachTypedLinkRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val typedLinkSpecifier
        : zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly =
      zio.aws.clouddirectory.model.TypedLinkSpecifier
        .wrap(impl.typedLinkSpecifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.DetachTypedLinkRequest
  ): zio.aws.clouddirectory.model.DetachTypedLinkRequest.ReadOnly = new Wrapper(
    impl
  )
}
