package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{TypedLinkName, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteTypedLinkFacetRequest(
    schemaArn: Arn,
    name: TypedLinkName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.DeleteTypedLinkFacetRequest = {
    import DeleteTypedLinkFacetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.DeleteTypedLinkFacetRequest
      .builder()
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .name(TypedLinkName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.DeleteTypedLinkFacetRequest.ReadOnly =
    zio.aws.clouddirectory.model.DeleteTypedLinkFacetRequest
      .wrap(buildAwsValue())
}
object DeleteTypedLinkFacetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.DeleteTypedLinkFacetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.DeleteTypedLinkFacetRequest =
      zio.aws.clouddirectory.model.DeleteTypedLinkFacetRequest(schemaArn, name)
    def schemaArn: Arn
    def name: TypedLinkName
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
    def getName: ZIO[Any, Nothing, TypedLinkName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.DeleteTypedLinkFacetRequest
  ) extends zio.aws.clouddirectory.model.DeleteTypedLinkFacetRequest.ReadOnly {
    override val schemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.schemaArn())
    override val name: TypedLinkName =
      zio.aws.clouddirectory.model.primitives.TypedLinkName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.DeleteTypedLinkFacetRequest
  ): zio.aws.clouddirectory.model.DeleteTypedLinkFacetRequest.ReadOnly =
    new Wrapper(impl)
}
