package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.SchemaName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateSchemaRequest(name: SchemaName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.CreateSchemaRequest = {
    import CreateSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.CreateSchemaRequest
      .builder()
      .name(SchemaName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.CreateSchemaRequest.ReadOnly =
    zio.aws.clouddirectory.model.CreateSchemaRequest.wrap(buildAwsValue())
}
object CreateSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.CreateSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.CreateSchemaRequest =
      zio.aws.clouddirectory.model.CreateSchemaRequest(name)
    def name: SchemaName
    def getName: ZIO[Any, Nothing, SchemaName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateSchemaRequest
  ) extends zio.aws.clouddirectory.model.CreateSchemaRequest.ReadOnly {
    override val name: SchemaName =
      zio.aws.clouddirectory.model.primitives.SchemaName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateSchemaRequest
  ): zio.aws.clouddirectory.model.CreateSchemaRequest.ReadOnly = new Wrapper(
    impl
  )
}
