package zio.aws.clouddirectory.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.clouddirectory.model.primitives.{NumberResults, NextToken}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDirectoriesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[NumberResults] = Optional.Absent,
    state: Optional[zio.aws.clouddirectory.model.DirectoryState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest = {
    import ListDirectoriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.ListDirectoriesRequest.ReadOnly =
    zio.aws.clouddirectory.model.ListDirectoriesRequest.wrap(buildAwsValue())
}
object ListDirectoriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListDirectoriesRequest =
      zio.aws.clouddirectory.model.ListDirectoriesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        state.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[NumberResults]
    def state: Optional[zio.aws.clouddirectory.model.DirectoryState]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getState
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.DirectoryState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest
  ) extends zio.aws.clouddirectory.model.ListDirectoriesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val maxResults: Optional[NumberResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
    override val state: Optional[zio.aws.clouddirectory.model.DirectoryState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.clouddirectory.model.DirectoryState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest
  ): zio.aws.clouddirectory.model.ListDirectoriesRequest.ReadOnly = new Wrapper(
    impl
  )
}
