package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{NextToken, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDevelopmentSchemaArnsResponse(
    schemaArns: Optional[Iterable[Arn]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsResponse = {
    import ListDevelopmentSchemaArnsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsResponse
      .builder()
      .optionallyWith(
        schemaArns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.schemaArns)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListDevelopmentSchemaArnsResponse.ReadOnly =
    zio.aws.clouddirectory.model.ListDevelopmentSchemaArnsResponse
      .wrap(buildAwsValue())
}
object ListDevelopmentSchemaArnsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.ListDevelopmentSchemaArnsResponse =
      zio.aws.clouddirectory.model.ListDevelopmentSchemaArnsResponse(
        schemaArns.map(value => value),
        nextToken.map(value => value)
      )
    def schemaArns: Optional[List[Arn]]
    def nextToken: Optional[NextToken]
    def getSchemaArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("schemaArns", schemaArns)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsResponse
  ) extends zio.aws.clouddirectory.model.ListDevelopmentSchemaArnsResponse.ReadOnly {
    override val schemaArns: Optional[List[Arn]] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.primitives.Arn(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsResponse
  ): zio.aws.clouddirectory.model.ListDevelopmentSchemaArnsResponse.ReadOnly =
    new Wrapper(impl)
}
