package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.ObjectIdentifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IndexAttachment(
    indexedAttributes: Optional[
      Iterable[zio.aws.clouddirectory.model.AttributeKeyAndValue]
    ] = Optional.Absent,
    objectIdentifier: Optional[ObjectIdentifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.IndexAttachment = {
    import IndexAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.IndexAttachment
      .builder()
      .optionallyWith(
        indexedAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.indexedAttributes)
      .optionallyWith(
        objectIdentifier.map(value =>
          ObjectIdentifier.unwrap(value): java.lang.String
        )
      )(_.objectIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.IndexAttachment.ReadOnly =
    zio.aws.clouddirectory.model.IndexAttachment.wrap(buildAwsValue())
}
object IndexAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.IndexAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.IndexAttachment =
      zio.aws.clouddirectory.model.IndexAttachment(
        indexedAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        objectIdentifier.map(value => value)
      )
    def indexedAttributes: Optional[
      List[zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly]
    ]
    def objectIdentifier: Optional[ObjectIdentifier]
    def getIndexedAttributes: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly
    ]] = AwsError.unwrapOptionField("indexedAttributes", indexedAttributes)
    def getObjectIdentifier: ZIO[Any, AwsError, ObjectIdentifier] =
      AwsError.unwrapOptionField("objectIdentifier", objectIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.IndexAttachment
  ) extends zio.aws.clouddirectory.model.IndexAttachment.ReadOnly {
    override val indexedAttributes: Optional[
      List[zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.indexedAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.AttributeKeyAndValue.wrap(item)
        }.toList
      )
    override val objectIdentifier: Optional[ObjectIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectIdentifier())
        .map(value =>
          zio.aws.clouddirectory.model.primitives.ObjectIdentifier(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.IndexAttachment
  ): zio.aws.clouddirectory.model.IndexAttachment.ReadOnly = new Wrapper(impl)
}
