package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{FacetName, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetFacetRequest(schemaArn: Arn, name: FacetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.GetFacetRequest = {
    import GetFacetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.GetFacetRequest
      .builder()
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .name(FacetName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.GetFacetRequest.ReadOnly =
    zio.aws.clouddirectory.model.GetFacetRequest.wrap(buildAwsValue())
}
object GetFacetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.GetFacetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.GetFacetRequest =
      zio.aws.clouddirectory.model.GetFacetRequest(schemaArn, name)
    def schemaArn: Arn
    def name: FacetName
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
    def getName: ZIO[Any, Nothing, FacetName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetFacetRequest
  ) extends zio.aws.clouddirectory.model.GetFacetRequest.ReadOnly {
    override val schemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.schemaArn())
    override val name: FacetName =
      zio.aws.clouddirectory.model.primitives.FacetName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetFacetRequest
  ): zio.aws.clouddirectory.model.GetFacetRequest.ReadOnly = new Wrapper(impl)
}
