package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DisableDirectoryRequest(directoryArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.DisableDirectoryRequest = {
    import DisableDirectoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.DisableDirectoryRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.DisableDirectoryRequest.ReadOnly =
    zio.aws.clouddirectory.model.DisableDirectoryRequest.wrap(buildAwsValue())
}
object DisableDirectoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.DisableDirectoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.DisableDirectoryRequest =
      zio.aws.clouddirectory.model.DisableDirectoryRequest(directoryArn)
    def directoryArn: Arn
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.DisableDirectoryRequest
  ) extends zio.aws.clouddirectory.model.DisableDirectoryRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.DisableDirectoryRequest
  ): zio.aws.clouddirectory.model.DisableDirectoryRequest.ReadOnly =
    new Wrapper(impl)
}
