package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDirectoryResponse(directoryArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.DeleteDirectoryResponse = {
    import DeleteDirectoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.DeleteDirectoryResponse
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.DeleteDirectoryResponse.ReadOnly =
    zio.aws.clouddirectory.model.DeleteDirectoryResponse.wrap(buildAwsValue())
}
object DeleteDirectoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.DeleteDirectoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.DeleteDirectoryResponse =
      zio.aws.clouddirectory.model.DeleteDirectoryResponse(directoryArn)
    def directoryArn: Arn
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.DeleteDirectoryResponse
  ) extends zio.aws.clouddirectory.model.DeleteDirectoryResponse.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.DeleteDirectoryResponse
  ): zio.aws.clouddirectory.model.DeleteDirectoryResponse.ReadOnly =
    new Wrapper(impl)
}
