package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListObjectParentPathsResponse(
    pathToObjectIdentifiersList: Option[
      Iterable[zio.aws.clouddirectory.model.PathToObjectIdentifiers]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsResponse = {
    import ListObjectParentPathsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsResponse
      .builder()
      .optionallyWith(
        pathToObjectIdentifiersList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pathToObjectIdentifiersList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListObjectParentPathsResponse.ReadOnly =
    zio.aws.clouddirectory.model.ListObjectParentPathsResponse
      .wrap(buildAwsValue())
}
object ListObjectParentPathsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListObjectParentPathsResponse =
      zio.aws.clouddirectory.model.ListObjectParentPathsResponse(
        pathToObjectIdentifiersList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def pathToObjectIdentifiersList: Option[
      List[zio.aws.clouddirectory.model.PathToObjectIdentifiers.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getPathToObjectIdentifiersList: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.PathToObjectIdentifiers.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pathToObjectIdentifiersList",
      pathToObjectIdentifiersList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsResponse
  ) extends zio.aws.clouddirectory.model.ListObjectParentPathsResponse.ReadOnly {
    override val pathToObjectIdentifiersList: Option[
      List[zio.aws.clouddirectory.model.PathToObjectIdentifiers.ReadOnly]
    ] = scala
      .Option(impl.pathToObjectIdentifiersList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.PathToObjectIdentifiers.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsResponse
  ): zio.aws.clouddirectory.model.ListObjectParentPathsResponse.ReadOnly =
    new Wrapper(impl)
}
