package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{
  NextToken,
  ObjectIdentifier,
  LinkName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListObjectChildrenResponse(
    children: Option[Map[LinkName, ObjectIdentifier]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenResponse = {
    import ListObjectChildrenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenResponse
      .builder()
      .optionallyWith(
        children.map(value =>
          value
            .map({ case (key, value) =>
              (LinkName.unwrap(key): java.lang.String) -> (ObjectIdentifier
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.children)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListObjectChildrenResponse.ReadOnly =
    zio.aws.clouddirectory.model.ListObjectChildrenResponse
      .wrap(buildAwsValue())
}
object ListObjectChildrenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListObjectChildrenResponse =
      zio.aws.clouddirectory.model.ListObjectChildrenResponse(
        children.map(value => value),
        nextToken.map(value => value)
      )
    def children: Option[Map[LinkName, ObjectIdentifier]]
    def nextToken: Option[NextToken]
    def getChildren: ZIO[Any, AwsError, Map[LinkName, ObjectIdentifier]] =
      AwsError.unwrapOptionField("children", children)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenResponse
  ) extends zio.aws.clouddirectory.model.ListObjectChildrenResponse.ReadOnly {
    override val children: Option[Map[LinkName, ObjectIdentifier]] = scala
      .Option(impl.children())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.clouddirectory.model.primitives.LinkName(
              key
            ) -> zio.aws.clouddirectory.model.primitives.ObjectIdentifier(value)
          })
          .toMap
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenResponse
  ): zio.aws.clouddirectory.model.ListObjectChildrenResponse.ReadOnly =
    new Wrapper(impl)
}
