package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchWriteOperationResponse(
    createObject: Option[
      zio.aws.clouddirectory.model.BatchCreateObjectResponse
    ] = None,
    attachObject: Option[
      zio.aws.clouddirectory.model.BatchAttachObjectResponse
    ] = None,
    detachObject: Option[
      zio.aws.clouddirectory.model.BatchDetachObjectResponse
    ] = None,
    updateObjectAttributes: Option[
      zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse
    ] = None,
    deleteObject: Option[
      zio.aws.clouddirectory.model.BatchDeleteObjectResponse
    ] = None,
    addFacetToObject: Option[
      zio.aws.clouddirectory.model.BatchAddFacetToObjectResponse
    ] = None,
    removeFacetFromObject: Option[
      zio.aws.clouddirectory.model.BatchRemoveFacetFromObjectResponse
    ] = None,
    attachPolicy: Option[
      zio.aws.clouddirectory.model.BatchAttachPolicyResponse
    ] = None,
    detachPolicy: Option[
      zio.aws.clouddirectory.model.BatchDetachPolicyResponse
    ] = None,
    createIndex: Option[zio.aws.clouddirectory.model.BatchCreateIndexResponse] =
      None,
    attachToIndex: Option[
      zio.aws.clouddirectory.model.BatchAttachToIndexResponse
    ] = None,
    detachFromIndex: Option[
      zio.aws.clouddirectory.model.BatchDetachFromIndexResponse
    ] = None,
    attachTypedLink: Option[
      zio.aws.clouddirectory.model.BatchAttachTypedLinkResponse
    ] = None,
    detachTypedLink: Option[
      zio.aws.clouddirectory.model.BatchDetachTypedLinkResponse
    ] = None,
    updateLinkAttributes: Option[
      zio.aws.clouddirectory.model.BatchUpdateLinkAttributesResponse
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperationResponse = {
    import BatchWriteOperationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperationResponse
      .builder()
      .optionallyWith(createObject.map(value => value.buildAwsValue()))(
        _.createObject
      )
      .optionallyWith(attachObject.map(value => value.buildAwsValue()))(
        _.attachObject
      )
      .optionallyWith(detachObject.map(value => value.buildAwsValue()))(
        _.detachObject
      )
      .optionallyWith(
        updateObjectAttributes.map(value => value.buildAwsValue())
      )(_.updateObjectAttributes)
      .optionallyWith(deleteObject.map(value => value.buildAwsValue()))(
        _.deleteObject
      )
      .optionallyWith(addFacetToObject.map(value => value.buildAwsValue()))(
        _.addFacetToObject
      )
      .optionallyWith(
        removeFacetFromObject.map(value => value.buildAwsValue())
      )(_.removeFacetFromObject)
      .optionallyWith(attachPolicy.map(value => value.buildAwsValue()))(
        _.attachPolicy
      )
      .optionallyWith(detachPolicy.map(value => value.buildAwsValue()))(
        _.detachPolicy
      )
      .optionallyWith(createIndex.map(value => value.buildAwsValue()))(
        _.createIndex
      )
      .optionallyWith(attachToIndex.map(value => value.buildAwsValue()))(
        _.attachToIndex
      )
      .optionallyWith(detachFromIndex.map(value => value.buildAwsValue()))(
        _.detachFromIndex
      )
      .optionallyWith(attachTypedLink.map(value => value.buildAwsValue()))(
        _.attachTypedLink
      )
      .optionallyWith(detachTypedLink.map(value => value.buildAwsValue()))(
        _.detachTypedLink
      )
      .optionallyWith(updateLinkAttributes.map(value => value.buildAwsValue()))(
        _.updateLinkAttributes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchWriteOperationResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchWriteOperationResponse
      .wrap(buildAwsValue())
}
object BatchWriteOperationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchWriteOperationResponse =
      zio.aws.clouddirectory.model.BatchWriteOperationResponse(
        createObject.map(value => value.asEditable),
        attachObject.map(value => value.asEditable),
        detachObject.map(value => value.asEditable),
        updateObjectAttributes.map(value => value.asEditable),
        deleteObject.map(value => value.asEditable),
        addFacetToObject.map(value => value.asEditable),
        removeFacetFromObject.map(value => value.asEditable),
        attachPolicy.map(value => value.asEditable),
        detachPolicy.map(value => value.asEditable),
        createIndex.map(value => value.asEditable),
        attachToIndex.map(value => value.asEditable),
        detachFromIndex.map(value => value.asEditable),
        attachTypedLink.map(value => value.asEditable),
        detachTypedLink.map(value => value.asEditable),
        updateLinkAttributes.map(value => value.asEditable)
      )
    def createObject: Option[
      zio.aws.clouddirectory.model.BatchCreateObjectResponse.ReadOnly
    ]
    def attachObject: Option[
      zio.aws.clouddirectory.model.BatchAttachObjectResponse.ReadOnly
    ]
    def detachObject: Option[
      zio.aws.clouddirectory.model.BatchDetachObjectResponse.ReadOnly
    ]
    def updateObjectAttributes: Option[
      zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse.ReadOnly
    ]
    def deleteObject: Option[
      zio.aws.clouddirectory.model.BatchDeleteObjectResponse.ReadOnly
    ]
    def addFacetToObject: Option[
      zio.aws.clouddirectory.model.BatchAddFacetToObjectResponse.ReadOnly
    ]
    def removeFacetFromObject: Option[
      zio.aws.clouddirectory.model.BatchRemoveFacetFromObjectResponse.ReadOnly
    ]
    def attachPolicy: Option[
      zio.aws.clouddirectory.model.BatchAttachPolicyResponse.ReadOnly
    ]
    def detachPolicy: Option[
      zio.aws.clouddirectory.model.BatchDetachPolicyResponse.ReadOnly
    ]
    def createIndex
        : Option[zio.aws.clouddirectory.model.BatchCreateIndexResponse.ReadOnly]
    def attachToIndex: Option[
      zio.aws.clouddirectory.model.BatchAttachToIndexResponse.ReadOnly
    ]
    def detachFromIndex: Option[
      zio.aws.clouddirectory.model.BatchDetachFromIndexResponse.ReadOnly
    ]
    def attachTypedLink: Option[
      zio.aws.clouddirectory.model.BatchAttachTypedLinkResponse.ReadOnly
    ]
    def detachTypedLink: Option[
      zio.aws.clouddirectory.model.BatchDetachTypedLinkResponse.ReadOnly
    ]
    def updateLinkAttributes: Option[
      zio.aws.clouddirectory.model.BatchUpdateLinkAttributesResponse.ReadOnly
    ]
    def getCreateObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchCreateObjectResponse.ReadOnly
    ] = AwsError.unwrapOptionField("createObject", createObject)
    def getAttachObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAttachObjectResponse.ReadOnly
    ] = AwsError.unwrapOptionField("attachObject", attachObject)
    def getDetachObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDetachObjectResponse.ReadOnly
    ] = AwsError.unwrapOptionField("detachObject", detachObject)
    def getUpdateObjectAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "updateObjectAttributes",
      updateObjectAttributes
    )
    def getDeleteObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDeleteObjectResponse.ReadOnly
    ] = AwsError.unwrapOptionField("deleteObject", deleteObject)
    def getAddFacetToObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAddFacetToObjectResponse.ReadOnly
    ] = AwsError.unwrapOptionField("addFacetToObject", addFacetToObject)
    def getRemoveFacetFromObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchRemoveFacetFromObjectResponse.ReadOnly
    ] =
      AwsError.unwrapOptionField("removeFacetFromObject", removeFacetFromObject)
    def getAttachPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAttachPolicyResponse.ReadOnly
    ] = AwsError.unwrapOptionField("attachPolicy", attachPolicy)
    def getDetachPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDetachPolicyResponse.ReadOnly
    ] = AwsError.unwrapOptionField("detachPolicy", detachPolicy)
    def getCreateIndex: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchCreateIndexResponse.ReadOnly
    ] = AwsError.unwrapOptionField("createIndex", createIndex)
    def getAttachToIndex: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAttachToIndexResponse.ReadOnly
    ] = AwsError.unwrapOptionField("attachToIndex", attachToIndex)
    def getDetachFromIndex: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDetachFromIndexResponse.ReadOnly
    ] = AwsError.unwrapOptionField("detachFromIndex", detachFromIndex)
    def getAttachTypedLink: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAttachTypedLinkResponse.ReadOnly
    ] = AwsError.unwrapOptionField("attachTypedLink", attachTypedLink)
    def getDetachTypedLink: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDetachTypedLinkResponse.ReadOnly
    ] = AwsError.unwrapOptionField("detachTypedLink", detachTypedLink)
    def getUpdateLinkAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchUpdateLinkAttributesResponse.ReadOnly
    ] = AwsError.unwrapOptionField("updateLinkAttributes", updateLinkAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperationResponse
  ) extends zio.aws.clouddirectory.model.BatchWriteOperationResponse.ReadOnly {
    override val createObject: Option[
      zio.aws.clouddirectory.model.BatchCreateObjectResponse.ReadOnly
    ] = scala
      .Option(impl.createObject())
      .map(value =>
        zio.aws.clouddirectory.model.BatchCreateObjectResponse.wrap(value)
      )
    override val attachObject: Option[
      zio.aws.clouddirectory.model.BatchAttachObjectResponse.ReadOnly
    ] = scala
      .Option(impl.attachObject())
      .map(value =>
        zio.aws.clouddirectory.model.BatchAttachObjectResponse.wrap(value)
      )
    override val detachObject: Option[
      zio.aws.clouddirectory.model.BatchDetachObjectResponse.ReadOnly
    ] = scala
      .Option(impl.detachObject())
      .map(value =>
        zio.aws.clouddirectory.model.BatchDetachObjectResponse.wrap(value)
      )
    override val updateObjectAttributes: Option[
      zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse.ReadOnly
    ] = scala
      .Option(impl.updateObjectAttributes())
      .map(value =>
        zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse
          .wrap(value)
      )
    override val deleteObject: Option[
      zio.aws.clouddirectory.model.BatchDeleteObjectResponse.ReadOnly
    ] = scala
      .Option(impl.deleteObject())
      .map(value =>
        zio.aws.clouddirectory.model.BatchDeleteObjectResponse.wrap(value)
      )
    override val addFacetToObject: Option[
      zio.aws.clouddirectory.model.BatchAddFacetToObjectResponse.ReadOnly
    ] = scala
      .Option(impl.addFacetToObject())
      .map(value =>
        zio.aws.clouddirectory.model.BatchAddFacetToObjectResponse.wrap(value)
      )
    override val removeFacetFromObject: Option[
      zio.aws.clouddirectory.model.BatchRemoveFacetFromObjectResponse.ReadOnly
    ] = scala
      .Option(impl.removeFacetFromObject())
      .map(value =>
        zio.aws.clouddirectory.model.BatchRemoveFacetFromObjectResponse
          .wrap(value)
      )
    override val attachPolicy: Option[
      zio.aws.clouddirectory.model.BatchAttachPolicyResponse.ReadOnly
    ] = scala
      .Option(impl.attachPolicy())
      .map(value =>
        zio.aws.clouddirectory.model.BatchAttachPolicyResponse.wrap(value)
      )
    override val detachPolicy: Option[
      zio.aws.clouddirectory.model.BatchDetachPolicyResponse.ReadOnly
    ] = scala
      .Option(impl.detachPolicy())
      .map(value =>
        zio.aws.clouddirectory.model.BatchDetachPolicyResponse.wrap(value)
      )
    override val createIndex: Option[
      zio.aws.clouddirectory.model.BatchCreateIndexResponse.ReadOnly
    ] = scala
      .Option(impl.createIndex())
      .map(value =>
        zio.aws.clouddirectory.model.BatchCreateIndexResponse.wrap(value)
      )
    override val attachToIndex: Option[
      zio.aws.clouddirectory.model.BatchAttachToIndexResponse.ReadOnly
    ] = scala
      .Option(impl.attachToIndex())
      .map(value =>
        zio.aws.clouddirectory.model.BatchAttachToIndexResponse.wrap(value)
      )
    override val detachFromIndex: Option[
      zio.aws.clouddirectory.model.BatchDetachFromIndexResponse.ReadOnly
    ] = scala
      .Option(impl.detachFromIndex())
      .map(value =>
        zio.aws.clouddirectory.model.BatchDetachFromIndexResponse.wrap(value)
      )
    override val attachTypedLink: Option[
      zio.aws.clouddirectory.model.BatchAttachTypedLinkResponse.ReadOnly
    ] = scala
      .Option(impl.attachTypedLink())
      .map(value =>
        zio.aws.clouddirectory.model.BatchAttachTypedLinkResponse.wrap(value)
      )
    override val detachTypedLink: Option[
      zio.aws.clouddirectory.model.BatchDetachTypedLinkResponse.ReadOnly
    ] = scala
      .Option(impl.detachTypedLink())
      .map(value =>
        zio.aws.clouddirectory.model.BatchDetachTypedLinkResponse.wrap(value)
      )
    override val updateLinkAttributes: Option[
      zio.aws.clouddirectory.model.BatchUpdateLinkAttributesResponse.ReadOnly
    ] = scala
      .Option(impl.updateLinkAttributes())
      .map(value =>
        zio.aws.clouddirectory.model.BatchUpdateLinkAttributesResponse
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperationResponse
  ): zio.aws.clouddirectory.model.BatchWriteOperationResponse.ReadOnly =
    new Wrapper(impl)
}
