package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchUpdateObjectAttributes(
    objectReference: zio.aws.clouddirectory.model.ObjectReference,
    attributeUpdates: Iterable[
      zio.aws.clouddirectory.model.ObjectAttributeUpdate
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributes = {
    import BatchUpdateObjectAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributes
      .builder()
      .objectReference(objectReference.buildAwsValue())
      .attributeUpdates(attributeUpdates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchUpdateObjectAttributes.ReadOnly =
    zio.aws.clouddirectory.model.BatchUpdateObjectAttributes
      .wrap(buildAwsValue())
}
object BatchUpdateObjectAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchUpdateObjectAttributes =
      zio.aws.clouddirectory.model.BatchUpdateObjectAttributes(
        objectReference.asEditable,
        attributeUpdates.map { item =>
          item.asEditable
        }
      )
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def attributeUpdates
        : List[zio.aws.clouddirectory.model.ObjectAttributeUpdate.ReadOnly]
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
    def getAttributeUpdates: ZIO[Any, Nothing, List[
      zio.aws.clouddirectory.model.ObjectAttributeUpdate.ReadOnly
    ]] = ZIO.succeed(attributeUpdates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributes
  ) extends zio.aws.clouddirectory.model.BatchUpdateObjectAttributes.ReadOnly {
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
    override val attributeUpdates
        : List[zio.aws.clouddirectory.model.ObjectAttributeUpdate.ReadOnly] =
      impl
        .attributeUpdates()
        .asScala
        .map { item =>
          zio.aws.clouddirectory.model.ObjectAttributeUpdate.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributes
  ): zio.aws.clouddirectory.model.BatchUpdateObjectAttributes.ReadOnly =
    new Wrapper(impl)
}
