package zio.aws.clouddirectory.model
import java.lang.Integer
import zio.aws.clouddirectory.model.primitives.{NumberResults, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchLookupPolicy(
    objectReference: zio.aws.clouddirectory.model.ObjectReference,
    nextToken: Option[NextToken] = None,
    maxResults: Option[NumberResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchLookupPolicy = {
    import BatchLookupPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchLookupPolicy
      .builder()
      .objectReference(objectReference.buildAwsValue())
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchLookupPolicy.ReadOnly =
    zio.aws.clouddirectory.model.BatchLookupPolicy.wrap(buildAwsValue())
}
object BatchLookupPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchLookupPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchLookupPolicy =
      zio.aws.clouddirectory.model.BatchLookupPolicy(
        objectReference.asEditable,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def nextToken: Option[NextToken]
    def maxResults: Option[NumberResults]
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchLookupPolicy
  ) extends zio.aws.clouddirectory.model.BatchLookupPolicy.ReadOnly {
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val maxResults: Option[NumberResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchLookupPolicy
  ): zio.aws.clouddirectory.model.BatchLookupPolicy.ReadOnly = new Wrapper(impl)
}
