package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchListOutgoingTypedLinksResponse(
    typedLinkSpecifiers: Option[
      Iterable[zio.aws.clouddirectory.model.TypedLinkSpecifier]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchListOutgoingTypedLinksResponse = {
    import BatchListOutgoingTypedLinksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchListOutgoingTypedLinksResponse
      .builder()
      .optionallyWith(
        typedLinkSpecifiers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.typedLinkSpecifiers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchListOutgoingTypedLinksResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchListOutgoingTypedLinksResponse
      .wrap(buildAwsValue())
}
object BatchListOutgoingTypedLinksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchListOutgoingTypedLinksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.BatchListOutgoingTypedLinksResponse =
      zio.aws.clouddirectory.model.BatchListOutgoingTypedLinksResponse(
        typedLinkSpecifiers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def typedLinkSpecifiers
        : Option[List[zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly]]
    def nextToken: Option[NextToken]
    def getTypedLinkSpecifiers: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    ]] = AwsError.unwrapOptionField("typedLinkSpecifiers", typedLinkSpecifiers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListOutgoingTypedLinksResponse
  ) extends zio.aws.clouddirectory.model.BatchListOutgoingTypedLinksResponse.ReadOnly {
    override val typedLinkSpecifiers: Option[
      List[zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly]
    ] = scala
      .Option(impl.typedLinkSpecifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.TypedLinkSpecifier.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListOutgoingTypedLinksResponse
  ): zio.aws.clouddirectory.model.BatchListOutgoingTypedLinksResponse.ReadOnly =
    new Wrapper(impl)
}
