package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{RuleKey, Bool, AttributeName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TypedLinkAttributeDefinition(
    name: AttributeName,
    `type`: zio.aws.clouddirectory.model.FacetAttributeType,
    defaultValue: Option[zio.aws.clouddirectory.model.TypedAttributeValue] =
      None,
    isImmutable: Option[Bool] = None,
    rules: Option[Map[RuleKey, zio.aws.clouddirectory.model.Rule]] = None,
    requiredBehavior: zio.aws.clouddirectory.model.RequiredAttributeBehavior
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeDefinition = {
    import TypedLinkAttributeDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeDefinition
      .builder()
      .name(AttributeName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(defaultValue.map(value => value.buildAwsValue()))(
        _.defaultValue
      )
      .optionallyWith(isImmutable.map(value => value: java.lang.Boolean))(
        _.isImmutable
      )
      .optionallyWith(
        rules.map(value =>
          value
            .map({ case (key, value) =>
              (RuleKey.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.rules)
      .requiredBehavior(requiredBehavior.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.ReadOnly =
    zio.aws.clouddirectory.model.TypedLinkAttributeDefinition
      .wrap(buildAwsValue())
}
object TypedLinkAttributeDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.TypedLinkAttributeDefinition =
      zio.aws.clouddirectory.model.TypedLinkAttributeDefinition(
        name,
        `type`,
        defaultValue.map(value => value.asEditable),
        isImmutable.map(value => value),
        rules.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        requiredBehavior
      )
    def name: AttributeName
    def `type`: zio.aws.clouddirectory.model.FacetAttributeType
    def defaultValue
        : Option[zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly]
    def isImmutable: Option[Bool]
    def rules: Option[Map[RuleKey, zio.aws.clouddirectory.model.Rule.ReadOnly]]
    def requiredBehavior: zio.aws.clouddirectory.model.RequiredAttributeBehavior
    def getName: ZIO[Any, Nothing, AttributeName] = ZIO.succeed(name)
    def getType
        : ZIO[Any, Nothing, zio.aws.clouddirectory.model.FacetAttributeType] =
      ZIO.succeed(`type`)
    def getDefaultValue: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly
    ] = AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getIsImmutable: ZIO[Any, AwsError, Bool] =
      AwsError.unwrapOptionField("isImmutable", isImmutable)
    def getRules: ZIO[Any, AwsError, Map[
      RuleKey,
      zio.aws.clouddirectory.model.Rule.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
    def getRequiredBehavior: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.RequiredAttributeBehavior
    ] = ZIO.succeed(requiredBehavior)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeDefinition
  ) extends zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.ReadOnly {
    override val name: AttributeName =
      zio.aws.clouddirectory.model.primitives.AttributeName(impl.name())
    override val `type`: zio.aws.clouddirectory.model.FacetAttributeType =
      zio.aws.clouddirectory.model.FacetAttributeType.wrap(impl.`type`())
    override val defaultValue
        : Option[zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly] =
      scala
        .Option(impl.defaultValue())
        .map(value =>
          zio.aws.clouddirectory.model.TypedAttributeValue.wrap(value)
        )
    override val isImmutable: Option[Bool] =
      scala.Option(impl.isImmutable()).map(value => value: Bool)
    override val rules
        : Option[Map[RuleKey, zio.aws.clouddirectory.model.Rule.ReadOnly]] =
      scala
        .Option(impl.rules())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.clouddirectory.model.primitives
                .RuleKey(key) -> zio.aws.clouddirectory.model.Rule.wrap(value)
            })
            .toMap
        )
    override val requiredBehavior
        : zio.aws.clouddirectory.model.RequiredAttributeBehavior =
      zio.aws.clouddirectory.model.RequiredAttributeBehavior
        .wrap(impl.requiredBehavior())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeDefinition
  ): zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.ReadOnly =
    new Wrapper(impl)
}
