package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{
  StringAttributeValue,
  NumberAttributeValue,
  DatetimeAttributeValue,
  BooleanAttributeValue,
  BinaryAttributeValue
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class TypedAttributeValue(
    stringValue: Option[StringAttributeValue] = None,
    binaryValue: Option[BinaryAttributeValue] = None,
    booleanValue: Option[BooleanAttributeValue] = None,
    numberValue: Option[NumberAttributeValue] = None,
    datetimeValue: Option[DatetimeAttributeValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue = {
    import TypedAttributeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue
      .builder()
      .optionallyWith(
        stringValue.map(value =>
          StringAttributeValue.unwrap(value): java.lang.String
        )
      )(_.stringValue)
      .optionallyWith(
        binaryValue.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.binaryValue)
      .optionallyWith(
        booleanValue.map(value =>
          BooleanAttributeValue.unwrap(value): java.lang.Boolean
        )
      )(_.booleanValue)
      .optionallyWith(
        numberValue.map(value =>
          NumberAttributeValue.unwrap(value): java.lang.String
        )
      )(_.numberValue)
      .optionallyWith(
        datetimeValue.map(value =>
          DatetimeAttributeValue.unwrap(value): Instant
        )
      )(_.datetimeValue)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly =
    zio.aws.clouddirectory.model.TypedAttributeValue.wrap(buildAwsValue())
}
object TypedAttributeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.TypedAttributeValue =
      zio.aws.clouddirectory.model.TypedAttributeValue(
        stringValue.map(value => value),
        binaryValue.map(value => value),
        booleanValue.map(value => value),
        numberValue.map(value => value),
        datetimeValue.map(value => value)
      )
    def stringValue: Option[StringAttributeValue]
    def binaryValue: Option[BinaryAttributeValue]
    def booleanValue: Option[BooleanAttributeValue]
    def numberValue: Option[NumberAttributeValue]
    def datetimeValue: Option[DatetimeAttributeValue]
    def getStringValue: ZIO[Any, AwsError, StringAttributeValue] =
      AwsError.unwrapOptionField("stringValue", stringValue)
    def getBinaryValue: ZIO[Any, AwsError, BinaryAttributeValue] =
      AwsError.unwrapOptionField("binaryValue", binaryValue)
    def getBooleanValue: ZIO[Any, AwsError, BooleanAttributeValue] =
      AwsError.unwrapOptionField("booleanValue", booleanValue)
    def getNumberValue: ZIO[Any, AwsError, NumberAttributeValue] =
      AwsError.unwrapOptionField("numberValue", numberValue)
    def getDatetimeValue: ZIO[Any, AwsError, DatetimeAttributeValue] =
      AwsError.unwrapOptionField("datetimeValue", datetimeValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue
  ) extends zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly {
    override val stringValue: Option[StringAttributeValue] = scala
      .Option(impl.stringValue())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.StringAttributeValue(value)
      )
    override val binaryValue: Option[BinaryAttributeValue] = scala
      .Option(impl.binaryValue())
      .map(value =>
        zio.aws.clouddirectory.model.primitives
          .BinaryAttributeValue(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val booleanValue: Option[BooleanAttributeValue] = scala
      .Option(impl.booleanValue())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.BooleanAttributeValue(value)
      )
    override val numberValue: Option[NumberAttributeValue] = scala
      .Option(impl.numberValue())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberAttributeValue(value)
      )
    override val datetimeValue: Option[DatetimeAttributeValue] = scala
      .Option(impl.datetimeValue())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.DatetimeAttributeValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue
  ): zio.aws.clouddirectory.model.TypedAttributeValue.ReadOnly = new Wrapper(
    impl
  )
}
