package zio.aws.clouddirectory.model
import scala.jdk.CollectionConverters.*
sealed trait RequiredAttributeBehavior {
  def unwrap: software.amazon.awssdk.services.clouddirectory.model.RequiredAttributeBehavior
}
object RequiredAttributeBehavior {
  def wrap(
      value: software.amazon.awssdk.services.clouddirectory.model.RequiredAttributeBehavior
  ): zio.aws.clouddirectory.model.RequiredAttributeBehavior = value match {
    case software.amazon.awssdk.services.clouddirectory.model.RequiredAttributeBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.clouddirectory.model.RequiredAttributeBehavior.REQUIRED_ALWAYS =>
      val r = REQUIRED_ALWAYS
      r
    case software.amazon.awssdk.services.clouddirectory.model.RequiredAttributeBehavior.NOT_REQUIRED =>
      val r = NOT_REQUIRED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.clouddirectory.model.RequiredAttributeBehavior {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.RequiredAttributeBehavior =
      software.amazon.awssdk.services.clouddirectory.model.RequiredAttributeBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object REQUIRED_ALWAYS
      extends zio.aws.clouddirectory.model.RequiredAttributeBehavior {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.RequiredAttributeBehavior =
      software.amazon.awssdk.services.clouddirectory.model.RequiredAttributeBehavior.REQUIRED_ALWAYS
  }
  case object NOT_REQUIRED
      extends zio.aws.clouddirectory.model.RequiredAttributeBehavior {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.RequiredAttributeBehavior =
      software.amazon.awssdk.services.clouddirectory.model.RequiredAttributeBehavior.NOT_REQUIRED
  }
}
