package zio.aws.clouddirectory.model
import java.lang.Integer
import zio.aws.clouddirectory.model.primitives.{
  NumberResults,
  NextToken,
  TypedLinkName,
  Arn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTypedLinkFacetAttributesRequest(
    schemaArn: Arn,
    name: TypedLinkName,
    nextToken: Option[NextToken] = None,
    maxResults: Option[NumberResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesRequest = {
    import ListTypedLinkFacetAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesRequest
      .builder()
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .name(TypedLinkName.unwrap(name): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListTypedLinkFacetAttributesRequest.ReadOnly =
    zio.aws.clouddirectory.model.ListTypedLinkFacetAttributesRequest
      .wrap(buildAwsValue())
}
object ListTypedLinkFacetAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.ListTypedLinkFacetAttributesRequest =
      zio.aws.clouddirectory.model.ListTypedLinkFacetAttributesRequest(
        schemaArn,
        name,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def schemaArn: Arn
    def name: TypedLinkName
    def nextToken: Option[NextToken]
    def maxResults: Option[NumberResults]
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
    def getName: ZIO[Any, Nothing, TypedLinkName] = ZIO.succeed(name)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesRequest
  ) extends zio.aws.clouddirectory.model.ListTypedLinkFacetAttributesRequest.ReadOnly {
    override val schemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.schemaArn())
    override val name: TypedLinkName =
      zio.aws.clouddirectory.model.primitives.TypedLinkName(impl.name())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val maxResults: Option[NumberResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesRequest
  ): zio.aws.clouddirectory.model.ListTypedLinkFacetAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
