package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LinkAttributeUpdate(
    attributeKey: Option[zio.aws.clouddirectory.model.AttributeKey] = None,
    attributeAction: Option[zio.aws.clouddirectory.model.LinkAttributeAction] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.LinkAttributeUpdate = {
    import LinkAttributeUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.LinkAttributeUpdate
      .builder()
      .optionallyWith(attributeKey.map(value => value.buildAwsValue()))(
        _.attributeKey
      )
      .optionallyWith(attributeAction.map(value => value.buildAwsValue()))(
        _.attributeAction
      )
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.LinkAttributeUpdate.ReadOnly =
    zio.aws.clouddirectory.model.LinkAttributeUpdate.wrap(buildAwsValue())
}
object LinkAttributeUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.LinkAttributeUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.LinkAttributeUpdate =
      zio.aws.clouddirectory.model.LinkAttributeUpdate(
        attributeKey.map(value => value.asEditable),
        attributeAction.map(value => value.asEditable)
      )
    def attributeKey: Option[zio.aws.clouddirectory.model.AttributeKey.ReadOnly]
    def attributeAction
        : Option[zio.aws.clouddirectory.model.LinkAttributeAction.ReadOnly]
    def getAttributeKey: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.AttributeKey.ReadOnly
    ] = AwsError.unwrapOptionField("attributeKey", attributeKey)
    def getAttributeAction: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.LinkAttributeAction.ReadOnly
    ] = AwsError.unwrapOptionField("attributeAction", attributeAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.LinkAttributeUpdate
  ) extends zio.aws.clouddirectory.model.LinkAttributeUpdate.ReadOnly {
    override val attributeKey
        : Option[zio.aws.clouddirectory.model.AttributeKey.ReadOnly] = scala
      .Option(impl.attributeKey())
      .map(value => zio.aws.clouddirectory.model.AttributeKey.wrap(value))
    override val attributeAction
        : Option[zio.aws.clouddirectory.model.LinkAttributeAction.ReadOnly] =
      scala
        .Option(impl.attributeAction())
        .map(value =>
          zio.aws.clouddirectory.model.LinkAttributeAction.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.LinkAttributeUpdate
  ): zio.aws.clouddirectory.model.LinkAttributeUpdate.ReadOnly = new Wrapper(
    impl
  )
}
