package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchWriteOperation(
    createObject: Option[zio.aws.clouddirectory.model.BatchCreateObject] = None,
    attachObject: Option[zio.aws.clouddirectory.model.BatchAttachObject] = None,
    detachObject: Option[zio.aws.clouddirectory.model.BatchDetachObject] = None,
    updateObjectAttributes: Option[
      zio.aws.clouddirectory.model.BatchUpdateObjectAttributes
    ] = None,
    deleteObject: Option[zio.aws.clouddirectory.model.BatchDeleteObject] = None,
    addFacetToObject: Option[
      zio.aws.clouddirectory.model.BatchAddFacetToObject
    ] = None,
    removeFacetFromObject: Option[
      zio.aws.clouddirectory.model.BatchRemoveFacetFromObject
    ] = None,
    attachPolicy: Option[zio.aws.clouddirectory.model.BatchAttachPolicy] = None,
    detachPolicy: Option[zio.aws.clouddirectory.model.BatchDetachPolicy] = None,
    createIndex: Option[zio.aws.clouddirectory.model.BatchCreateIndex] = None,
    attachToIndex: Option[zio.aws.clouddirectory.model.BatchAttachToIndex] =
      None,
    detachFromIndex: Option[zio.aws.clouddirectory.model.BatchDetachFromIndex] =
      None,
    attachTypedLink: Option[zio.aws.clouddirectory.model.BatchAttachTypedLink] =
      None,
    detachTypedLink: Option[zio.aws.clouddirectory.model.BatchDetachTypedLink] =
      None,
    updateLinkAttributes: Option[
      zio.aws.clouddirectory.model.BatchUpdateLinkAttributes
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperation = {
    import BatchWriteOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperation
      .builder()
      .optionallyWith(createObject.map(value => value.buildAwsValue()))(
        _.createObject
      )
      .optionallyWith(attachObject.map(value => value.buildAwsValue()))(
        _.attachObject
      )
      .optionallyWith(detachObject.map(value => value.buildAwsValue()))(
        _.detachObject
      )
      .optionallyWith(
        updateObjectAttributes.map(value => value.buildAwsValue())
      )(_.updateObjectAttributes)
      .optionallyWith(deleteObject.map(value => value.buildAwsValue()))(
        _.deleteObject
      )
      .optionallyWith(addFacetToObject.map(value => value.buildAwsValue()))(
        _.addFacetToObject
      )
      .optionallyWith(
        removeFacetFromObject.map(value => value.buildAwsValue())
      )(_.removeFacetFromObject)
      .optionallyWith(attachPolicy.map(value => value.buildAwsValue()))(
        _.attachPolicy
      )
      .optionallyWith(detachPolicy.map(value => value.buildAwsValue()))(
        _.detachPolicy
      )
      .optionallyWith(createIndex.map(value => value.buildAwsValue()))(
        _.createIndex
      )
      .optionallyWith(attachToIndex.map(value => value.buildAwsValue()))(
        _.attachToIndex
      )
      .optionallyWith(detachFromIndex.map(value => value.buildAwsValue()))(
        _.detachFromIndex
      )
      .optionallyWith(attachTypedLink.map(value => value.buildAwsValue()))(
        _.attachTypedLink
      )
      .optionallyWith(detachTypedLink.map(value => value.buildAwsValue()))(
        _.detachTypedLink
      )
      .optionallyWith(updateLinkAttributes.map(value => value.buildAwsValue()))(
        _.updateLinkAttributes
      )
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchWriteOperation.ReadOnly =
    zio.aws.clouddirectory.model.BatchWriteOperation.wrap(buildAwsValue())
}
object BatchWriteOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchWriteOperation =
      zio.aws.clouddirectory.model.BatchWriteOperation(
        createObject.map(value => value.asEditable),
        attachObject.map(value => value.asEditable),
        detachObject.map(value => value.asEditable),
        updateObjectAttributes.map(value => value.asEditable),
        deleteObject.map(value => value.asEditable),
        addFacetToObject.map(value => value.asEditable),
        removeFacetFromObject.map(value => value.asEditable),
        attachPolicy.map(value => value.asEditable),
        detachPolicy.map(value => value.asEditable),
        createIndex.map(value => value.asEditable),
        attachToIndex.map(value => value.asEditable),
        detachFromIndex.map(value => value.asEditable),
        attachTypedLink.map(value => value.asEditable),
        detachTypedLink.map(value => value.asEditable),
        updateLinkAttributes.map(value => value.asEditable)
      )
    def createObject
        : Option[zio.aws.clouddirectory.model.BatchCreateObject.ReadOnly]
    def attachObject
        : Option[zio.aws.clouddirectory.model.BatchAttachObject.ReadOnly]
    def detachObject
        : Option[zio.aws.clouddirectory.model.BatchDetachObject.ReadOnly]
    def updateObjectAttributes: Option[
      zio.aws.clouddirectory.model.BatchUpdateObjectAttributes.ReadOnly
    ]
    def deleteObject
        : Option[zio.aws.clouddirectory.model.BatchDeleteObject.ReadOnly]
    def addFacetToObject
        : Option[zio.aws.clouddirectory.model.BatchAddFacetToObject.ReadOnly]
    def removeFacetFromObject: Option[
      zio.aws.clouddirectory.model.BatchRemoveFacetFromObject.ReadOnly
    ]
    def attachPolicy
        : Option[zio.aws.clouddirectory.model.BatchAttachPolicy.ReadOnly]
    def detachPolicy
        : Option[zio.aws.clouddirectory.model.BatchDetachPolicy.ReadOnly]
    def createIndex
        : Option[zio.aws.clouddirectory.model.BatchCreateIndex.ReadOnly]
    def attachToIndex
        : Option[zio.aws.clouddirectory.model.BatchAttachToIndex.ReadOnly]
    def detachFromIndex
        : Option[zio.aws.clouddirectory.model.BatchDetachFromIndex.ReadOnly]
    def attachTypedLink
        : Option[zio.aws.clouddirectory.model.BatchAttachTypedLink.ReadOnly]
    def detachTypedLink
        : Option[zio.aws.clouddirectory.model.BatchDetachTypedLink.ReadOnly]
    def updateLinkAttributes: Option[
      zio.aws.clouddirectory.model.BatchUpdateLinkAttributes.ReadOnly
    ]
    def getCreateObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchCreateObject.ReadOnly
    ] = AwsError.unwrapOptionField("createObject", createObject)
    def getAttachObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAttachObject.ReadOnly
    ] = AwsError.unwrapOptionField("attachObject", attachObject)
    def getDetachObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDetachObject.ReadOnly
    ] = AwsError.unwrapOptionField("detachObject", detachObject)
    def getUpdateObjectAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchUpdateObjectAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "updateObjectAttributes",
      updateObjectAttributes
    )
    def getDeleteObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDeleteObject.ReadOnly
    ] = AwsError.unwrapOptionField("deleteObject", deleteObject)
    def getAddFacetToObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAddFacetToObject.ReadOnly
    ] = AwsError.unwrapOptionField("addFacetToObject", addFacetToObject)
    def getRemoveFacetFromObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchRemoveFacetFromObject.ReadOnly
    ] =
      AwsError.unwrapOptionField("removeFacetFromObject", removeFacetFromObject)
    def getAttachPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAttachPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("attachPolicy", attachPolicy)
    def getDetachPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDetachPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("detachPolicy", detachPolicy)
    def getCreateIndex: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchCreateIndex.ReadOnly
    ] = AwsError.unwrapOptionField("createIndex", createIndex)
    def getAttachToIndex: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAttachToIndex.ReadOnly
    ] = AwsError.unwrapOptionField("attachToIndex", attachToIndex)
    def getDetachFromIndex: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDetachFromIndex.ReadOnly
    ] = AwsError.unwrapOptionField("detachFromIndex", detachFromIndex)
    def getAttachTypedLink: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAttachTypedLink.ReadOnly
    ] = AwsError.unwrapOptionField("attachTypedLink", attachTypedLink)
    def getDetachTypedLink: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDetachTypedLink.ReadOnly
    ] = AwsError.unwrapOptionField("detachTypedLink", detachTypedLink)
    def getUpdateLinkAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchUpdateLinkAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("updateLinkAttributes", updateLinkAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperation
  ) extends zio.aws.clouddirectory.model.BatchWriteOperation.ReadOnly {
    override val createObject
        : Option[zio.aws.clouddirectory.model.BatchCreateObject.ReadOnly] =
      scala
        .Option(impl.createObject())
        .map(value =>
          zio.aws.clouddirectory.model.BatchCreateObject.wrap(value)
        )
    override val attachObject
        : Option[zio.aws.clouddirectory.model.BatchAttachObject.ReadOnly] =
      scala
        .Option(impl.attachObject())
        .map(value =>
          zio.aws.clouddirectory.model.BatchAttachObject.wrap(value)
        )
    override val detachObject
        : Option[zio.aws.clouddirectory.model.BatchDetachObject.ReadOnly] =
      scala
        .Option(impl.detachObject())
        .map(value =>
          zio.aws.clouddirectory.model.BatchDetachObject.wrap(value)
        )
    override val updateObjectAttributes: Option[
      zio.aws.clouddirectory.model.BatchUpdateObjectAttributes.ReadOnly
    ] = scala
      .Option(impl.updateObjectAttributes())
      .map(value =>
        zio.aws.clouddirectory.model.BatchUpdateObjectAttributes.wrap(value)
      )
    override val deleteObject
        : Option[zio.aws.clouddirectory.model.BatchDeleteObject.ReadOnly] =
      scala
        .Option(impl.deleteObject())
        .map(value =>
          zio.aws.clouddirectory.model.BatchDeleteObject.wrap(value)
        )
    override val addFacetToObject
        : Option[zio.aws.clouddirectory.model.BatchAddFacetToObject.ReadOnly] =
      scala
        .Option(impl.addFacetToObject())
        .map(value =>
          zio.aws.clouddirectory.model.BatchAddFacetToObject.wrap(value)
        )
    override val removeFacetFromObject: Option[
      zio.aws.clouddirectory.model.BatchRemoveFacetFromObject.ReadOnly
    ] = scala
      .Option(impl.removeFacetFromObject())
      .map(value =>
        zio.aws.clouddirectory.model.BatchRemoveFacetFromObject.wrap(value)
      )
    override val attachPolicy
        : Option[zio.aws.clouddirectory.model.BatchAttachPolicy.ReadOnly] =
      scala
        .Option(impl.attachPolicy())
        .map(value =>
          zio.aws.clouddirectory.model.BatchAttachPolicy.wrap(value)
        )
    override val detachPolicy
        : Option[zio.aws.clouddirectory.model.BatchDetachPolicy.ReadOnly] =
      scala
        .Option(impl.detachPolicy())
        .map(value =>
          zio.aws.clouddirectory.model.BatchDetachPolicy.wrap(value)
        )
    override val createIndex
        : Option[zio.aws.clouddirectory.model.BatchCreateIndex.ReadOnly] = scala
      .Option(impl.createIndex())
      .map(value => zio.aws.clouddirectory.model.BatchCreateIndex.wrap(value))
    override val attachToIndex
        : Option[zio.aws.clouddirectory.model.BatchAttachToIndex.ReadOnly] =
      scala
        .Option(impl.attachToIndex())
        .map(value =>
          zio.aws.clouddirectory.model.BatchAttachToIndex.wrap(value)
        )
    override val detachFromIndex
        : Option[zio.aws.clouddirectory.model.BatchDetachFromIndex.ReadOnly] =
      scala
        .Option(impl.detachFromIndex())
        .map(value =>
          zio.aws.clouddirectory.model.BatchDetachFromIndex.wrap(value)
        )
    override val attachTypedLink
        : Option[zio.aws.clouddirectory.model.BatchAttachTypedLink.ReadOnly] =
      scala
        .Option(impl.attachTypedLink())
        .map(value =>
          zio.aws.clouddirectory.model.BatchAttachTypedLink.wrap(value)
        )
    override val detachTypedLink
        : Option[zio.aws.clouddirectory.model.BatchDetachTypedLink.ReadOnly] =
      scala
        .Option(impl.detachTypedLink())
        .map(value =>
          zio.aws.clouddirectory.model.BatchDetachTypedLink.wrap(value)
        )
    override val updateLinkAttributes: Option[
      zio.aws.clouddirectory.model.BatchUpdateLinkAttributes.ReadOnly
    ] = scala
      .Option(impl.updateLinkAttributes())
      .map(value =>
        zio.aws.clouddirectory.model.BatchUpdateLinkAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperation
  ): zio.aws.clouddirectory.model.BatchWriteOperation.ReadOnly = new Wrapper(
    impl
  )
}
