package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpgradeAppliedSchemaResponse(
    upgradedSchemaArn: Option[Arn] = None,
    directoryArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.UpgradeAppliedSchemaResponse = {
    import UpgradeAppliedSchemaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.UpgradeAppliedSchemaResponse
      .builder()
      .optionallyWith(
        upgradedSchemaArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.upgradedSchemaArn)
      .optionallyWith(
        directoryArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.directoryArn)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.UpgradeAppliedSchemaResponse.ReadOnly =
    zio.aws.clouddirectory.model.UpgradeAppliedSchemaResponse
      .wrap(buildAwsValue())
}
object UpgradeAppliedSchemaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.UpgradeAppliedSchemaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.UpgradeAppliedSchemaResponse =
      zio.aws.clouddirectory.model.UpgradeAppliedSchemaResponse(
        upgradedSchemaArn.map(value => value),
        directoryArn.map(value => value)
      )
    def upgradedSchemaArn: Option[Arn]
    def directoryArn: Option[Arn]
    def getUpgradedSchemaArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("upgradedSchemaArn", upgradedSchemaArn)
    def getDirectoryArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("directoryArn", directoryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.UpgradeAppliedSchemaResponse
  ) extends zio.aws.clouddirectory.model.UpgradeAppliedSchemaResponse.ReadOnly {
    override val upgradedSchemaArn: Option[Arn] = scala
      .Option(impl.upgradedSchemaArn())
      .map(value => zio.aws.clouddirectory.model.primitives.Arn(value))
    override val directoryArn: Option[Arn] = scala
      .Option(impl.directoryArn())
      .map(value => zio.aws.clouddirectory.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.UpgradeAppliedSchemaResponse
  ): zio.aws.clouddirectory.model.UpgradeAppliedSchemaResponse.ReadOnly =
    new Wrapper(impl)
}
