package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Tag(
    key: Option[TagKey] = None,
    value: Option[TagValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.Tag
      .builder()
      .optionallyWith(key.map(value => TagKey.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(
        value.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.Tag.ReadOnly =
    zio.aws.clouddirectory.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.Tag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.Tag =
      zio.aws.clouddirectory.model
        .Tag(key.map(value => value), value.map(value => value))
    def key: Option[TagKey]
    def value: Option[TagValue]
    def getKey: ZIO[Any, AwsError, TagKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.Tag
  ) extends zio.aws.clouddirectory.model.Tag.ReadOnly {
    override val key: Option[TagKey] = scala
      .Option(impl.key())
      .map(value => zio.aws.clouddirectory.model.primitives.TagKey(value))
    override val value: Option[TagValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.clouddirectory.model.primitives.TagValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.Tag
  ): zio.aws.clouddirectory.model.Tag.ReadOnly = new Wrapper(impl)
}
