package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTypedLinkFacetAttributesResponse(
    attributes: Option[
      Iterable[zio.aws.clouddirectory.model.TypedLinkAttributeDefinition]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesResponse = {
    import ListTypedLinkFacetAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListTypedLinkFacetAttributesResponse.ReadOnly =
    zio.aws.clouddirectory.model.ListTypedLinkFacetAttributesResponse
      .wrap(buildAwsValue())
}
object ListTypedLinkFacetAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.ListTypedLinkFacetAttributesResponse =
      zio.aws.clouddirectory.model.ListTypedLinkFacetAttributesResponse(
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def attributes: Option[
      List[zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesResponse
  ) extends zio.aws.clouddirectory.model.ListTypedLinkFacetAttributesResponse.ReadOnly {
    override val attributes: Option[
      List[zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.ReadOnly]
    ] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesResponse
  ): zio.aws.clouddirectory.model.ListTypedLinkFacetAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
