package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{NextToken, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListPublishedSchemaArnsResponse(
    schemaArns: Option[Iterable[Arn]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsResponse = {
    import ListPublishedSchemaArnsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsResponse
      .builder()
      .optionallyWith(
        schemaArns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.schemaArns)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListPublishedSchemaArnsResponse.ReadOnly =
    zio.aws.clouddirectory.model.ListPublishedSchemaArnsResponse
      .wrap(buildAwsValue())
}
object ListPublishedSchemaArnsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.ListPublishedSchemaArnsResponse =
      zio.aws.clouddirectory.model.ListPublishedSchemaArnsResponse(
        schemaArns.map(value => value),
        nextToken.map(value => value)
      )
    def schemaArns: Option[List[Arn]]
    def nextToken: Option[NextToken]
    def getSchemaArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("schemaArns", schemaArns)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsResponse
  ) extends zio.aws.clouddirectory.model.ListPublishedSchemaArnsResponse.ReadOnly {
    override val schemaArns: Option[List[Arn]] = scala
      .Option(impl.schemaArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.primitives.Arn(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsResponse
  ): zio.aws.clouddirectory.model.ListPublishedSchemaArnsResponse.ReadOnly =
    new Wrapper(impl)
}
