package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSchemaAsJsonRequest(schemaArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.GetSchemaAsJsonRequest = {
    import GetSchemaAsJsonRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.GetSchemaAsJsonRequest
      .builder()
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.GetSchemaAsJsonRequest.ReadOnly =
    zio.aws.clouddirectory.model.GetSchemaAsJsonRequest.wrap(buildAwsValue())
}
object GetSchemaAsJsonRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.GetSchemaAsJsonRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.GetSchemaAsJsonRequest =
      zio.aws.clouddirectory.model.GetSchemaAsJsonRequest(schemaArn)
    def schemaArn: Arn
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetSchemaAsJsonRequest
  ) extends zio.aws.clouddirectory.model.GetSchemaAsJsonRequest.ReadOnly {
    override val schemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.schemaArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetSchemaAsJsonRequest
  ): zio.aws.clouddirectory.model.GetSchemaAsJsonRequest.ReadOnly = new Wrapper(
    impl
  )
}
