package zio.aws.clouddirectory.model
import scala.jdk.CollectionConverters.*
sealed trait FacetStyle {
  def unwrap: software.amazon.awssdk.services.clouddirectory.model.FacetStyle
}
object FacetStyle {
  def wrap(
      value: software.amazon.awssdk.services.clouddirectory.model.FacetStyle
  ): zio.aws.clouddirectory.model.FacetStyle = value match {
    case software.amazon.awssdk.services.clouddirectory.model.FacetStyle.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.clouddirectory.model.FacetStyle.STATIC =>
      val r = STATIC
      r
    case software.amazon.awssdk.services.clouddirectory.model.FacetStyle.DYNAMIC =>
      val r = DYNAMIC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.clouddirectory.model.FacetStyle {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.FacetStyle =
      software.amazon.awssdk.services.clouddirectory.model.FacetStyle.UNKNOWN_TO_SDK_VERSION
  }
  case object STATIC extends zio.aws.clouddirectory.model.FacetStyle {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.FacetStyle =
      software.amazon.awssdk.services.clouddirectory.model.FacetStyle.STATIC
  }
  case object DYNAMIC extends zio.aws.clouddirectory.model.FacetStyle {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.FacetStyle =
      software.amazon.awssdk.services.clouddirectory.model.FacetStyle.DYNAMIC
  }
}
