package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DisableDirectoryResponse(directoryArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.DisableDirectoryResponse = {
    import DisableDirectoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.DisableDirectoryResponse
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.DisableDirectoryResponse.ReadOnly =
    zio.aws.clouddirectory.model.DisableDirectoryResponse.wrap(buildAwsValue())
}
object DisableDirectoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.DisableDirectoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.DisableDirectoryResponse =
      zio.aws.clouddirectory.model.DisableDirectoryResponse(directoryArn)
    def directoryArn: Arn
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.DisableDirectoryResponse
  ) extends zio.aws.clouddirectory.model.DisableDirectoryResponse.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.DisableDirectoryResponse
  ): zio.aws.clouddirectory.model.DisableDirectoryResponse.ReadOnly =
    new Wrapper(impl)
}
