package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DetachPolicyRequest(
    directoryArn: Arn,
    policyReference: zio.aws.clouddirectory.model.ObjectReference,
    objectReference: zio.aws.clouddirectory.model.ObjectReference
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.DetachPolicyRequest = {
    import DetachPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.DetachPolicyRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .policyReference(policyReference.buildAwsValue())
      .objectReference(objectReference.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.DetachPolicyRequest.ReadOnly =
    zio.aws.clouddirectory.model.DetachPolicyRequest.wrap(buildAwsValue())
}
object DetachPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.DetachPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.DetachPolicyRequest =
      zio.aws.clouddirectory.model.DetachPolicyRequest(
        directoryArn,
        policyReference.asEditable,
        objectReference.asEditable
      )
    def directoryArn: Arn
    def policyReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getPolicyReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(policyReference)
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.DetachPolicyRequest
  ) extends zio.aws.clouddirectory.model.DetachPolicyRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val policyReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.policyReference())
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.DetachPolicyRequest
  ): zio.aws.clouddirectory.model.DetachPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
