package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.ObjectIdentifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DetachObjectResponse(
    detachedObjectIdentifier: Option[ObjectIdentifier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.DetachObjectResponse = {
    import DetachObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.DetachObjectResponse
      .builder()
      .optionallyWith(
        detachedObjectIdentifier.map(value =>
          ObjectIdentifier.unwrap(value): java.lang.String
        )
      )(_.detachedObjectIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.DetachObjectResponse.ReadOnly =
    zio.aws.clouddirectory.model.DetachObjectResponse.wrap(buildAwsValue())
}
object DetachObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.DetachObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.DetachObjectResponse =
      zio.aws.clouddirectory.model
        .DetachObjectResponse(detachedObjectIdentifier.map(value => value))
    def detachedObjectIdentifier: Option[ObjectIdentifier]
    def getDetachedObjectIdentifier: ZIO[Any, AwsError, ObjectIdentifier] =
      AwsError.unwrapOptionField(
        "detachedObjectIdentifier",
        detachedObjectIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.DetachObjectResponse
  ) extends zio.aws.clouddirectory.model.DetachObjectResponse.ReadOnly {
    override val detachedObjectIdentifier: Option[ObjectIdentifier] = scala
      .Option(impl.detachedObjectIdentifier())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.ObjectIdentifier(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.DetachObjectResponse
  ): zio.aws.clouddirectory.model.DetachObjectResponse.ReadOnly = new Wrapper(
    impl
  )
}
