package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{LinkName, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DetachObjectRequest(
    directoryArn: Arn,
    parentReference: zio.aws.clouddirectory.model.ObjectReference,
    linkName: LinkName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.DetachObjectRequest = {
    import DetachObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.DetachObjectRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .parentReference(parentReference.buildAwsValue())
      .linkName(LinkName.unwrap(linkName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.DetachObjectRequest.ReadOnly =
    zio.aws.clouddirectory.model.DetachObjectRequest.wrap(buildAwsValue())
}
object DetachObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.DetachObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.DetachObjectRequest =
      zio.aws.clouddirectory.model
        .DetachObjectRequest(directoryArn, parentReference.asEditable, linkName)
    def directoryArn: Arn
    def parentReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def linkName: LinkName
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getParentReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(parentReference)
    def getLinkName: ZIO[Any, Nothing, LinkName] = ZIO.succeed(linkName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.DetachObjectRequest
  ) extends zio.aws.clouddirectory.model.DetachObjectRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val parentReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.parentReference())
    override val linkName: LinkName =
      zio.aws.clouddirectory.model.primitives.LinkName(impl.linkName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.DetachObjectRequest
  ): zio.aws.clouddirectory.model.DetachObjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
