package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.ObjectIdentifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchUpdateObjectAttributesResponse(
    objectIdentifier: Option[ObjectIdentifier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributesResponse = {
    import BatchUpdateObjectAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributesResponse
      .builder()
      .optionallyWith(
        objectIdentifier.map(value =>
          ObjectIdentifier.unwrap(value): java.lang.String
        )
      )(_.objectIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse
      .wrap(buildAwsValue())
}
object BatchUpdateObjectAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse =
      zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse(
        objectIdentifier.map(value => value)
      )
    def objectIdentifier: Option[ObjectIdentifier]
    def getObjectIdentifier: ZIO[Any, AwsError, ObjectIdentifier] =
      AwsError.unwrapOptionField("objectIdentifier", objectIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributesResponse
  ) extends zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse.ReadOnly {
    override val objectIdentifier: Option[ObjectIdentifier] = scala
      .Option(impl.objectIdentifier())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.ObjectIdentifier(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributesResponse
  ): zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
