package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchReadRequest(
    directoryArn: Arn,
    operations: Iterable[zio.aws.clouddirectory.model.BatchReadOperation],
    consistencyLevel: Option[zio.aws.clouddirectory.model.ConsistencyLevel] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchReadRequest = {
    import BatchReadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchReadRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .operations(operations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(consistencyLevel.map(value => value.unwrap))(
        _.consistencyLevel
      )
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchReadRequest.ReadOnly =
    zio.aws.clouddirectory.model.BatchReadRequest.wrap(buildAwsValue())
}
object BatchReadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchReadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchReadRequest =
      zio.aws.clouddirectory.model.BatchReadRequest(
        directoryArn,
        operations.map { item =>
          item.asEditable
        },
        consistencyLevel.map(value => value)
      )
    def directoryArn: Arn
    def operations
        : List[zio.aws.clouddirectory.model.BatchReadOperation.ReadOnly]
    def consistencyLevel: Option[zio.aws.clouddirectory.model.ConsistencyLevel]
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getOperations: ZIO[Any, Nothing, List[
      zio.aws.clouddirectory.model.BatchReadOperation.ReadOnly
    ]] = ZIO.succeed(operations)
    def getConsistencyLevel
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.ConsistencyLevel] =
      AwsError.unwrapOptionField("consistencyLevel", consistencyLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchReadRequest
  ) extends zio.aws.clouddirectory.model.BatchReadRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val operations
        : List[zio.aws.clouddirectory.model.BatchReadOperation.ReadOnly] = impl
      .operations()
      .asScala
      .map { item =>
        zio.aws.clouddirectory.model.BatchReadOperation.wrap(item)
      }
      .toList
    override val consistencyLevel
        : Option[zio.aws.clouddirectory.model.ConsistencyLevel] = scala
      .Option(impl.consistencyLevel())
      .map(value => zio.aws.clouddirectory.model.ConsistencyLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchReadRequest
  ): zio.aws.clouddirectory.model.BatchReadRequest.ReadOnly = new Wrapper(impl)
}
