package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchLookupPolicyResponse(
    policyToPathList: Option[
      Iterable[zio.aws.clouddirectory.model.PolicyToPath]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchLookupPolicyResponse = {
    import BatchLookupPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchLookupPolicyResponse
      .builder()
      .optionallyWith(
        policyToPathList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyToPathList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchLookupPolicyResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchLookupPolicyResponse.wrap(buildAwsValue())
}
object BatchLookupPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchLookupPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchLookupPolicyResponse =
      zio.aws.clouddirectory.model.BatchLookupPolicyResponse(
        policyToPathList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def policyToPathList
        : Option[List[zio.aws.clouddirectory.model.PolicyToPath.ReadOnly]]
    def nextToken: Option[NextToken]
    def getPolicyToPathList: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.PolicyToPath.ReadOnly
    ]] = AwsError.unwrapOptionField("policyToPathList", policyToPathList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchLookupPolicyResponse
  ) extends zio.aws.clouddirectory.model.BatchLookupPolicyResponse.ReadOnly {
    override val policyToPathList
        : Option[List[zio.aws.clouddirectory.model.PolicyToPath.ReadOnly]] =
      scala
        .Option(impl.policyToPathList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.clouddirectory.model.PolicyToPath.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchLookupPolicyResponse
  ): zio.aws.clouddirectory.model.BatchLookupPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
