package zio.aws.clouddirectory.model
import java.lang.Integer
import zio.aws.clouddirectory.model.primitives.{NumberResults, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchListPolicyAttachments(
    policyReference: zio.aws.clouddirectory.model.ObjectReference,
    nextToken: Option[NextToken] = None,
    maxResults: Option[NumberResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchListPolicyAttachments = {
    import BatchListPolicyAttachments.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchListPolicyAttachments
      .builder()
      .policyReference(policyReference.buildAwsValue())
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchListPolicyAttachments.ReadOnly =
    zio.aws.clouddirectory.model.BatchListPolicyAttachments
      .wrap(buildAwsValue())
}
object BatchListPolicyAttachments {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchListPolicyAttachments
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchListPolicyAttachments =
      zio.aws.clouddirectory.model.BatchListPolicyAttachments(
        policyReference.asEditable,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def policyReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def nextToken: Option[NextToken]
    def maxResults: Option[NumberResults]
    def getPolicyReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(policyReference)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListPolicyAttachments
  ) extends zio.aws.clouddirectory.model.BatchListPolicyAttachments.ReadOnly {
    override val policyReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.policyReference())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val maxResults: Option[NumberResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListPolicyAttachments
  ): zio.aws.clouddirectory.model.BatchListPolicyAttachments.ReadOnly =
    new Wrapper(impl)
}
