package zio.aws.clouddirectory.model
import java.lang.Integer
import zio.aws.clouddirectory.model.primitives.{NumberResults, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchListOutgoingTypedLinks(
    objectReference: zio.aws.clouddirectory.model.ObjectReference,
    filterAttributeRanges: Option[
      Iterable[zio.aws.clouddirectory.model.TypedLinkAttributeRange]
    ] = None,
    filterTypedLink: Option[
      zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName
    ] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[NumberResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchListOutgoingTypedLinks = {
    import BatchListOutgoingTypedLinks.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchListOutgoingTypedLinks
      .builder()
      .objectReference(objectReference.buildAwsValue())
      .optionallyWith(
        filterAttributeRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filterAttributeRanges)
      .optionallyWith(filterTypedLink.map(value => value.buildAwsValue()))(
        _.filterTypedLink
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchListOutgoingTypedLinks.ReadOnly =
    zio.aws.clouddirectory.model.BatchListOutgoingTypedLinks
      .wrap(buildAwsValue())
}
object BatchListOutgoingTypedLinks {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchListOutgoingTypedLinks
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchListOutgoingTypedLinks =
      zio.aws.clouddirectory.model.BatchListOutgoingTypedLinks(
        objectReference.asEditable,
        filterAttributeRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filterTypedLink.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def filterAttributeRanges: Option[
      List[zio.aws.clouddirectory.model.TypedLinkAttributeRange.ReadOnly]
    ]
    def filterTypedLink: Option[
      zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName.ReadOnly
    ]
    def nextToken: Option[NextToken]
    def maxResults: Option[NumberResults]
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
    def getFilterAttributeRanges: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.TypedLinkAttributeRange.ReadOnly
    ]] =
      AwsError.unwrapOptionField("filterAttributeRanges", filterAttributeRanges)
    def getFilterTypedLink: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName.ReadOnly
    ] = AwsError.unwrapOptionField("filterTypedLink", filterTypedLink)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListOutgoingTypedLinks
  ) extends zio.aws.clouddirectory.model.BatchListOutgoingTypedLinks.ReadOnly {
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
    override val filterAttributeRanges: Option[
      List[zio.aws.clouddirectory.model.TypedLinkAttributeRange.ReadOnly]
    ] = scala
      .Option(impl.filterAttributeRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.TypedLinkAttributeRange.wrap(item)
        }.toList
      )
    override val filterTypedLink: Option[
      zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName.ReadOnly
    ] = scala
      .Option(impl.filterTypedLink())
      .map(value =>
        zio.aws.clouddirectory.model.TypedLinkSchemaAndFacetName.wrap(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val maxResults: Option[NumberResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListOutgoingTypedLinks
  ): zio.aws.clouddirectory.model.BatchListOutgoingTypedLinks.ReadOnly =
    new Wrapper(impl)
}
