package zio.aws.clouddirectory.model
import java.lang.Integer
import zio.aws.clouddirectory.model.primitives.{NumberResults, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchListObjectAttributes(
    objectReference: zio.aws.clouddirectory.model.ObjectReference,
    nextToken: Option[NextToken] = None,
    maxResults: Option[NumberResults] = None,
    facetFilter: Option[zio.aws.clouddirectory.model.SchemaFacet] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchListObjectAttributes = {
    import BatchListObjectAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchListObjectAttributes
      .builder()
      .objectReference(objectReference.buildAwsValue())
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(facetFilter.map(value => value.buildAwsValue()))(
        _.facetFilter
      )
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchListObjectAttributes.ReadOnly =
    zio.aws.clouddirectory.model.BatchListObjectAttributes.wrap(buildAwsValue())
}
object BatchListObjectAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchListObjectAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchListObjectAttributes =
      zio.aws.clouddirectory.model.BatchListObjectAttributes(
        objectReference.asEditable,
        nextToken.map(value => value),
        maxResults.map(value => value),
        facetFilter.map(value => value.asEditable)
      )
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def nextToken: Option[NextToken]
    def maxResults: Option[NumberResults]
    def facetFilter: Option[zio.aws.clouddirectory.model.SchemaFacet.ReadOnly]
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFacetFilter: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.SchemaFacet.ReadOnly
    ] = AwsError.unwrapOptionField("facetFilter", facetFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListObjectAttributes
  ) extends zio.aws.clouddirectory.model.BatchListObjectAttributes.ReadOnly {
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val maxResults: Option[NumberResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
    override val facetFilter
        : Option[zio.aws.clouddirectory.model.SchemaFacet.ReadOnly] = scala
      .Option(impl.facetFilter())
      .map(value => zio.aws.clouddirectory.model.SchemaFacet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListObjectAttributes
  ): zio.aws.clouddirectory.model.BatchListObjectAttributes.ReadOnly =
    new Wrapper(impl)
}
