package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{AttributeName, FacetName, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttributeKey(
    schemaArn: Arn,
    facetName: FacetName,
    name: AttributeName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.AttributeKey = {
    import AttributeKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.AttributeKey
      .builder()
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .facetName(FacetName.unwrap(facetName): java.lang.String)
      .name(AttributeName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.AttributeKey.ReadOnly =
    zio.aws.clouddirectory.model.AttributeKey.wrap(buildAwsValue())
}
object AttributeKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.AttributeKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.AttributeKey =
      zio.aws.clouddirectory.model.AttributeKey(schemaArn, facetName, name)
    def schemaArn: Arn
    def facetName: FacetName
    def name: AttributeName
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
    def getFacetName: ZIO[Any, Nothing, FacetName] = ZIO.succeed(facetName)
    def getName: ZIO[Any, Nothing, AttributeName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttributeKey
  ) extends zio.aws.clouddirectory.model.AttributeKey.ReadOnly {
    override val schemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.schemaArn())
    override val facetName: FacetName =
      zio.aws.clouddirectory.model.primitives.FacetName(impl.facetName())
    override val name: AttributeName =
      zio.aws.clouddirectory.model.primitives.AttributeName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttributeKey
  ): zio.aws.clouddirectory.model.AttributeKey.ReadOnly = new Wrapper(impl)
}
