package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ApplySchemaResponse(
    appliedSchemaArn: Option[Arn] = None,
    directoryArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ApplySchemaResponse = {
    import ApplySchemaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ApplySchemaResponse
      .builder()
      .optionallyWith(
        appliedSchemaArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.appliedSchemaArn)
      .optionallyWith(
        directoryArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.directoryArn)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.ApplySchemaResponse.ReadOnly =
    zio.aws.clouddirectory.model.ApplySchemaResponse.wrap(buildAwsValue())
}
object ApplySchemaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ApplySchemaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ApplySchemaResponse =
      zio.aws.clouddirectory.model.ApplySchemaResponse(
        appliedSchemaArn.map(value => value),
        directoryArn.map(value => value)
      )
    def appliedSchemaArn: Option[Arn]
    def directoryArn: Option[Arn]
    def getAppliedSchemaArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("appliedSchemaArn", appliedSchemaArn)
    def getDirectoryArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("directoryArn", directoryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ApplySchemaResponse
  ) extends zio.aws.clouddirectory.model.ApplySchemaResponse.ReadOnly {
    override val appliedSchemaArn: Option[Arn] = scala
      .Option(impl.appliedSchemaArn())
      .map(value => zio.aws.clouddirectory.model.primitives.Arn(value))
    override val directoryArn: Option[Arn] = scala
      .Option(impl.directoryArn())
      .map(value => zio.aws.clouddirectory.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ApplySchemaResponse
  ): zio.aws.clouddirectory.model.ApplySchemaResponse.ReadOnly = new Wrapper(
    impl
  )
}
