package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{Bool, Version, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpgradePublishedSchemaRequest(
    developmentSchemaArn: Arn,
    publishedSchemaArn: Arn,
    minorVersion: Version,
    dryRun: Option[Bool] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.UpgradePublishedSchemaRequest = {
    import UpgradePublishedSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.UpgradePublishedSchemaRequest
      .builder()
      .developmentSchemaArn(Arn.unwrap(developmentSchemaArn): java.lang.String)
      .publishedSchemaArn(Arn.unwrap(publishedSchemaArn): java.lang.String)
      .minorVersion(Version.unwrap(minorVersion): java.lang.String)
      .optionallyWith(
        dryRun.map(value => Bool.unwrap(value): java.lang.Boolean)
      )(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.UpgradePublishedSchemaRequest.ReadOnly =
    zio.aws.clouddirectory.model.UpgradePublishedSchemaRequest
      .wrap(buildAwsValue())
}
object UpgradePublishedSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.UpgradePublishedSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.UpgradePublishedSchemaRequest =
      zio.aws.clouddirectory.model.UpgradePublishedSchemaRequest(
        developmentSchemaArn,
        publishedSchemaArn,
        minorVersion,
        dryRun.map(value => value)
      )
    def developmentSchemaArn: Arn
    def publishedSchemaArn: Arn
    def minorVersion: Version
    def dryRun: Option[Bool]
    def getDevelopmentSchemaArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(developmentSchemaArn)
    def getPublishedSchemaArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(publishedSchemaArn)
    def getMinorVersion: ZIO[Any, Nothing, Version] = ZIO.succeed(minorVersion)
    def getDryRun: ZIO[Any, AwsError, Bool] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.UpgradePublishedSchemaRequest
  ) extends zio.aws.clouddirectory.model.UpgradePublishedSchemaRequest.ReadOnly {
    override val developmentSchemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.developmentSchemaArn())
    override val publishedSchemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.publishedSchemaArn())
    override val minorVersion: Version =
      zio.aws.clouddirectory.model.primitives.Version(impl.minorVersion())
    override val dryRun: Option[Bool] = scala
      .Option(impl.dryRun())
      .map(value => zio.aws.clouddirectory.model.primitives.Bool(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.UpgradePublishedSchemaRequest
  ): zio.aws.clouddirectory.model.UpgradePublishedSchemaRequest.ReadOnly =
    new Wrapper(impl)
}
