package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ObjectAttributeRange(
    attributeKey: Option[zio.aws.clouddirectory.model.AttributeKey] = None,
    range: Option[zio.aws.clouddirectory.model.TypedAttributeValueRange] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeRange = {
    import ObjectAttributeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeRange
      .builder()
      .optionallyWith(attributeKey.map(value => value.buildAwsValue()))(
        _.attributeKey
      )
      .optionallyWith(range.map(value => value.buildAwsValue()))(_.range)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.ObjectAttributeRange.ReadOnly =
    zio.aws.clouddirectory.model.ObjectAttributeRange.wrap(buildAwsValue())
}
object ObjectAttributeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ObjectAttributeRange =
      zio.aws.clouddirectory.model.ObjectAttributeRange(
        attributeKey.map(value => value.asEditable),
        range.map(value => value.asEditable)
      )
    def attributeKey: Option[zio.aws.clouddirectory.model.AttributeKey.ReadOnly]
    def range
        : Option[zio.aws.clouddirectory.model.TypedAttributeValueRange.ReadOnly]
    def getAttributeKey: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.AttributeKey.ReadOnly
    ] = AwsError.unwrapOptionField("attributeKey", attributeKey)
    def getRange: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.TypedAttributeValueRange.ReadOnly
    ] = AwsError.unwrapOptionField("range", range)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeRange
  ) extends zio.aws.clouddirectory.model.ObjectAttributeRange.ReadOnly {
    override val attributeKey
        : Option[zio.aws.clouddirectory.model.AttributeKey.ReadOnly] = scala
      .Option(impl.attributeKey())
      .map(value => zio.aws.clouddirectory.model.AttributeKey.wrap(value))
    override val range: Option[
      zio.aws.clouddirectory.model.TypedAttributeValueRange.ReadOnly
    ] = scala
      .Option(impl.range())
      .map(value =>
        zio.aws.clouddirectory.model.TypedAttributeValueRange.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeRange
  ): zio.aws.clouddirectory.model.ObjectAttributeRange.ReadOnly = new Wrapper(
    impl
  )
}
