package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{
  NextToken,
  LinkName,
  ObjectIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListObjectParentsResponse(
    parents: Option[Map[ObjectIdentifier, LinkName]] = None,
    nextToken: Option[NextToken] = None,
    parentLinks: Option[
      Iterable[zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsResponse = {
    import ListObjectParentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsResponse
      .builder()
      .optionallyWith(
        parents.map(value =>
          value
            .map({ case (key, value) =>
              (ObjectIdentifier.unwrap(key): java.lang.String) -> (LinkName
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.parents)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        parentLinks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parentLinks)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListObjectParentsResponse.ReadOnly =
    zio.aws.clouddirectory.model.ListObjectParentsResponse.wrap(buildAwsValue())
}
object ListObjectParentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListObjectParentsResponse =
      zio.aws.clouddirectory.model.ListObjectParentsResponse(
        parents.map(value => value),
        nextToken.map(value => value),
        parentLinks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def parents: Option[Map[ObjectIdentifier, LinkName]]
    def nextToken: Option[NextToken]
    def parentLinks: Option[List[
      zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple.ReadOnly
    ]]
    def getParents: ZIO[Any, AwsError, Map[ObjectIdentifier, LinkName]] =
      AwsError.unwrapOptionField("parents", parents)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getParentLinks: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple.ReadOnly
    ]] = AwsError.unwrapOptionField("parentLinks", parentLinks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsResponse
  ) extends zio.aws.clouddirectory.model.ListObjectParentsResponse.ReadOnly {
    override val parents: Option[Map[ObjectIdentifier, LinkName]] = scala
      .Option(impl.parents())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.clouddirectory.model.primitives.ObjectIdentifier(
              key
            ) -> zio.aws.clouddirectory.model.primitives.LinkName(value)
          })
          .toMap
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val parentLinks: Option[List[
      zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple.ReadOnly
    ]] = scala
      .Option(impl.parentLinks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsResponse
  ): zio.aws.clouddirectory.model.ListObjectParentsResponse.ReadOnly =
    new Wrapper(impl)
}
