package zio.aws.clouddirectory.model
import java.lang.Integer
import zio.aws.clouddirectory.model.primitives.{
  Bool,
  NumberResults,
  NextToken,
  Arn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListObjectParentsRequest(
    directoryArn: Arn,
    objectReference: zio.aws.clouddirectory.model.ObjectReference,
    nextToken: Option[NextToken] = None,
    maxResults: Option[NumberResults] = None,
    consistencyLevel: Option[zio.aws.clouddirectory.model.ConsistencyLevel] =
      None,
    includeAllLinksToEachParent: Option[Bool] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest = {
    import ListObjectParentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .objectReference(objectReference.buildAwsValue())
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(consistencyLevel.map(value => value.unwrap))(
        _.consistencyLevel
      )
      .optionallyWith(
        includeAllLinksToEachParent.map(value =>
          Bool.unwrap(value): java.lang.Boolean
        )
      )(_.includeAllLinksToEachParent)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListObjectParentsRequest.ReadOnly =
    zio.aws.clouddirectory.model.ListObjectParentsRequest.wrap(buildAwsValue())
}
object ListObjectParentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListObjectParentsRequest =
      zio.aws.clouddirectory.model.ListObjectParentsRequest(
        directoryArn,
        objectReference.asEditable,
        nextToken.map(value => value),
        maxResults.map(value => value),
        consistencyLevel.map(value => value),
        includeAllLinksToEachParent.map(value => value)
      )
    def directoryArn: Arn
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def nextToken: Option[NextToken]
    def maxResults: Option[NumberResults]
    def consistencyLevel: Option[zio.aws.clouddirectory.model.ConsistencyLevel]
    def includeAllLinksToEachParent: Option[Bool]
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getConsistencyLevel
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.ConsistencyLevel] =
      AwsError.unwrapOptionField("consistencyLevel", consistencyLevel)
    def getIncludeAllLinksToEachParent: ZIO[Any, AwsError, Bool] =
      AwsError.unwrapOptionField(
        "includeAllLinksToEachParent",
        includeAllLinksToEachParent
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest
  ) extends zio.aws.clouddirectory.model.ListObjectParentsRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val maxResults: Option[NumberResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
    override val consistencyLevel
        : Option[zio.aws.clouddirectory.model.ConsistencyLevel] = scala
      .Option(impl.consistencyLevel())
      .map(value => zio.aws.clouddirectory.model.ConsistencyLevel.wrap(value))
    override val includeAllLinksToEachParent: Option[Bool] = scala
      .Option(impl.includeAllLinksToEachParent())
      .map(value => zio.aws.clouddirectory.model.primitives.Bool(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest
  ): zio.aws.clouddirectory.model.ListObjectParentsRequest.ReadOnly =
    new Wrapper(impl)
}
