package zio.aws.clouddirectory.model
import java.lang.Integer
import zio.aws.clouddirectory.model.primitives.{NumberResults, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDirectoriesRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[NumberResults] = None,
    state: Option[zio.aws.clouddirectory.model.DirectoryState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest = {
    import ListDirectoriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.ListDirectoriesRequest.ReadOnly =
    zio.aws.clouddirectory.model.ListDirectoriesRequest.wrap(buildAwsValue())
}
object ListDirectoriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListDirectoriesRequest =
      zio.aws.clouddirectory.model.ListDirectoriesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        state.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[NumberResults]
    def state: Option[zio.aws.clouddirectory.model.DirectoryState]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getState
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.DirectoryState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest
  ) extends zio.aws.clouddirectory.model.ListDirectoriesRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val maxResults: Option[NumberResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
    override val state: Option[zio.aws.clouddirectory.model.DirectoryState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.clouddirectory.model.DirectoryState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest
  ): zio.aws.clouddirectory.model.ListDirectoriesRequest.ReadOnly = new Wrapper(
    impl
  )
}
